define('bitbucket/internal/page/repository/empty/empty-repository', ['module', 'exports', 'jquery', 'bitbucket/internal/util/events', 'bitbucket/util/state'], function (module, exports, _jquery, _events, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _events2 = _interopRequireDefault(_events);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var CWF_PANEL_ID = '#empty-repository-instructions';
    var URL_CHANGE_EVENT_PREFIX = 'bitbucket.internal.DO_NOT_USE.feature.repository.clone.protocol';

    var cloneUrl = void 0;
    var defaultBranch = void 0;

    var updateInstructions = function updateInstructions() {
        var templateNamespace = bitbucket.internal.feature.git.emptyRepository;
        var repository = _state2.default.getRepository();
        var user = _state2.default.getCurrentUser();

        (0, _jquery2.default)(CWF_PANEL_ID + '-welcome').html(templateNamespace.newToGit());
        (0, _jquery2.default)(CWF_PANEL_ID + '-read').html(templateNamespace.read({ user: user }));

        if (cloneUrl) {
            (0, _jquery2.default)(CWF_PANEL_ID + '-clone').html(templateNamespace.clone({ cloneUrl: cloneUrl }));

            /**
             * The `write` panel renders conditionally based on users permissions,
             * however jQuery .html function wont fail if the element doesn't exists.
             */
            (0, _jquery2.default)(CWF_PANEL_ID + '-write').html(templateNamespace.write({
                repository: repository,
                cloneUrl: cloneUrl,
                defaultBranch: defaultBranch
            }));
        }
    };

    var setCloneUrl = function setCloneUrl(module, newCloneUrl) {
        cloneUrl = newCloneUrl;
        updateInstructions();
    };

    var onReady = function onReady(_ref) {
        var defaultBranchName = _ref.displayId;

        defaultBranch = defaultBranchName;

        if (!cloneUrl) {
            cloneUrl = _state2.default.getRepository().cloneUrl;
        }

        updateInstructions();
    };

    _events2.default.on(URL_CHANGE_EVENT_PREFIX + '.initial', setCloneUrl);
    _events2.default.on(URL_CHANGE_EVENT_PREFIX + '.changed', setCloneUrl);

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});