define('bitbucket/internal/page/repository/settings/general/repository-settings', ['module', 'exports', '@atlassian/aui', 'jquery', 'lodash', 'bitbucket/internal/feature/project/project-selector/project-selector', 'bitbucket/internal/feature/repository/branch-selector/branch-selector', 'bitbucket/internal/feature/repository/cloneUrlGen/cloneUrlGen', 'bitbucket/internal/model/page-state', 'bitbucket/internal/util/error', 'bitbucket/internal/util/feature-enabled', 'bitbucket/internal/util/notifications/notifications', 'bitbucket/internal/util/set-dialog-buttons-disabled', 'bitbucket/internal/widget/confirm-dialog/confirm-dialog', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state'], function (module, exports, _aui, _jquery, _lodash, _projectSelector, _branchSelector, _cloneUrlGen, _pageState, _error, _featureEnabled, _notifications, _setDialogButtonsDisabled, _confirmDialog, _navbuilder, _server, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _projectSelector2 = _interopRequireDefault(_projectSelector);

    var _branchSelector2 = _interopRequireDefault(_branchSelector);

    var _cloneUrlGen2 = _interopRequireDefault(_cloneUrlGen);

    var _pageState2 = _interopRequireDefault(_pageState);

    var _error2 = _interopRequireDefault(_error);

    var notifications = _interopRequireWildcard(_notifications);

    var _setDialogButtonsDisabled2 = _interopRequireDefault(_setDialogButtonsDisabled);

    var _confirmDialog2 = _interopRequireDefault(_confirmDialog);

    var nav = _interopRequireWildcard(_navbuilder);

    var server = _interopRequireWildcard(_server);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var isRepositoryArchivingFeatureEnabled = (0, _featureEnabled.getFromProviderSync)('repository.archiving');
    var $dropdownTriggerEl = (0, _jquery2.default)('.manage-repo-menu-trigger');

    function createMoveDialog() {
        var content = bitbucket.internal.page.repository.settings.general.repositorySettings.moveRepositoryForm({
            repository: _pageState2.default.getRepository().toJSON()
        });

        var moveButton = aui.buttons.button({
            text: _aui.I18n.getText('bitbucket.web.button.move'),
            extraClasses: ['button', 'move-button', 'aui-button-primary']
        });

        var cancelButton = aui.buttons.button({
            text: _aui.I18n.getText('bitbucket.web.button.cancel'),
            type: 'link',
            extraClasses: 'cancel-button'
        });

        var moveDialog = (0, _aui.dialog2)(aui.dialog.dialog2({
            id: 'repository-move-dialog',
            titleText: _aui.I18n.getText('bitbucket.web.repository.move.title'),
            content: content,
            footerActionContent: moveButton + cancelButton
        }));

        // bind project selector
        var $projectSelectorTrigger = moveDialog.$el.find('#moveProjectSelector');
        var projectSelector = new _projectSelector2.default($projectSelectorTrigger, {
            field: $projectSelectorTrigger.next('input')
        });

        // bind cloneUrlGen
        var $repoName = moveDialog.$el.find('#moveName');
        var $cloneUrl = moveDialog.$el.find('.clone-url-generated span');
        _cloneUrlGen2.default.bindUrlGeneration($cloneUrl, {
            elementsToWatch: [$repoName, $projectSelectorTrigger],
            getProject: projectSelector.getSelectedItem.bind(projectSelector),
            getRepoName: $repoName.val.bind($repoName)
        });

        function moveRepository() {
            var name = moveDialog.$el.find('#moveName').val();
            var project = projectSelector.getSelectedItem().toJSON();

            if (name === _pageState2.default.getRepository().getName() && project.key === _pageState2.default.getProject().getKey()) {
                // nothing to save. just close the dialog
                moveDialog.hide();
                $dropdownTriggerEl.focus();

                return;
            }

            (0, _setDialogButtonsDisabled2.default)(moveDialog, true);
            var $button = moveDialog.$el.find('.move-button');
            $button.get(0).busy();

            server.rest({
                type: 'PUT',
                url: nav.rest().repository(_state2.default.getRepository()).build(),
                data: {
                    name: name,
                    project: project
                },
                statusCode: {
                    // Don't handle these globally. We will want to show
                    // an error message in the form
                    400: false,
                    409: false
                }
            }).done(function (repository) {
                var name = repository.name,
                    slug = repository.slug,
                    _repository$project = repository.project,
                    projectName = _repository$project.name,
                    projectKey = _repository$project.key;

                notifications.addFlash(
                // It is possible to rename the repository only in the move dialog.
                projectKey === _pageState2.default.getProject().getKey() ? _aui.I18n.getText('bitbucket.web.repository.rename.success', _pageState2.default.getRepository().getName(), name) : _aui.I18n.getText('bitbucket.web.repository.move.success', name, projectName));
                location.href = nav.project(projectKey).repo(slug).settings().build();
            }).fail(function (xhr, testStatus, errorThrown, data) {
                _error2.default.setFormErrors(moveDialog.$el.find('form.aui'),
                // The move dialog uses different field names to prevent duplicate ids.
                // transform relevant contexts to something errorUtil will understand
                _lodash2.default.chain(data.errors).reject({ context: 'slug' }).map(function (error) {
                    var context = error.context;


                    if (context === 'project' || context === 'name') {
                        error.context = 'move' + context.charAt(0).toUpperCase() + context.slice(1);
                    }

                    return error;
                }).value());
            }).always(function () {
                (0, _setDialogButtonsDisabled2.default)(moveDialog, false);
                $button.get(0).idle();
            });
        }

        moveDialog.$el.find('form.aui').on('submit', function (e) {
            e.preventDefault();
            moveRepository();
        });
        moveDialog.$el.find('.move-button').click(moveRepository);
        moveDialog.$el.find('.cancel-button').click(function () {
            moveDialog.hide();
            $dropdownTriggerEl.focus();
        });

        return moveDialog;
    }

    function initMoveButton(moveButtonSelector) {
        var repo = _pageState2.default.getRepository().toJSON();

        if (repo.archived) {
            (0, _jquery2.default)(moveButtonSelector).prop('disabled', true).attr('aria-disabled', true);
        } else {
            var dialog = void 0;
            (0, _jquery2.default)(moveButtonSelector).on('click', function (e) {
                e.preventDefault();
                if (!dialog) {
                    dialog = createMoveDialog();
                }
                dialog.show();
                _error2.default.clearFormErrors(dialog.$el);
            });
        }
    }

    var ARCHIVE_DIALOG_CONTENT = {
        titleText: _aui.I18n.getText('bitbucket.web.repository.archive.title'),
        panelContent: _aui.I18n.getText('bitbucket.web.repository.archive.description'),
        submitText: _aui.I18n.getText('bitbucket.web.repository.button.archive')
    };

    var UNARCHIVE_DIALOG_CONTENT = {
        titleText: _aui.I18n.getText('bitbucket.web.repository.unarchive.title'),
        panelContent: _aui.I18n.getText('bitbucket.web.repository.unarchive.description'),
        submitText: _aui.I18n.getText('bitbucket.web.repository.button.unarchive')
    };

    function archiveRequest(repo, archived, removeDialog) {
        server.rest({
            type: 'PUT',
            url: nav.rest().repository(_state2.default.getRepository()).build(),
            data: {
                archived: !archived
            },
            statusCode: {
                403: function _() {
                    var notificationBody = bitbucket.internal.page.repository.settings.general.repositorySettings.archiveRepositoryErrorFlagBody({
                        url: nav.repository(repo).allPullRequests().withParams({ showDrafts: true }).build()
                    });

                    (0, _aui.flag)({
                        title: _aui.I18n.getText('bitbucket.web.repository.archive.403.error.title'),
                        body: notificationBody,
                        close: 'manual',
                        type: 'error'
                    });

                    return false;
                }
            }
        }).done(function (repository) {
            var archived = repository.archived;


            if (!archived) {
                notifications.addFlash(_aui.I18n.getText('bitbucket.web.repository.unarchive.success.flag.title'), {
                    type: 'success',
                    close: 'auto'
                });
            }

            document.location.reload();
        }).always(removeDialog);
    }

    function initArchiveButton(archiveButtonSelector) {
        var repo = _pageState2.default.getRepository().toJSON();
        var archived = repo.archived;

        if (archived) {
            (0, _jquery2.default)('#banner-archive-repository-link').text(_aui.I18n.getText('bitbucket.web.repository.archived.banner.unarchive.link'));
        }

        var dialogContent = archived ? UNARCHIVE_DIALOG_CONTENT : ARCHIVE_DIALOG_CONTENT;
        var archiveDialog = new _confirmDialog2.default(_extends({}, dialogContent, {
            id: 'archive-repository-dialog',
            confirmButtonClass: 'archive-button',
            submitToHref: false,
            focusTriggerElOnHide: $dropdownTriggerEl
        }));

        archiveDialog.attachTo(archiveButtonSelector);

        archiveDialog.addConfirmListener(function (promise, $trigger, removeDialog, dialog, $confirmButton) {
            $confirmButton.busy();
            archiveRequest(repo, archived, removeDialog);
        });
    }

    function initDeleteButton(deleteButtonSelector, deleteDialogArchiveButtonSelector) {
        var repo = _pageState2.default.getRepository().toJSON();
        var archived = repo.archived === true;
        var archiveButtonClass = deleteDialogArchiveButtonSelector.substring(1);

        var deleteRepositoryDialog = new _confirmDialog2.default(_extends({
            id: 'delete-repository-dialog',
            titleText: _aui.I18n.getText('bitbucket.web.repository.delete.title'),
            titleClass: 'warning-header',
            confirmButtonClass: 'delete-confirm-button'
        }, !archived && isRepositoryArchivingFeatureEnabled && {
            extraButtonClass: archiveButtonClass,
            extraButtonText: _aui.I18n.getText('bitbucket.web.repository.button.archive')
        }, {
            panelContent: bitbucket.internal.page.repository.settings.general.repositorySettings.deleteRepositoryDialog({
                repository: repo
            }),
            submitText: _aui.I18n.getText('bitbucket.web.button.delete'),
            height: 240,
            focusSelector: '.cancel-button',
            destructiveAction: true,
            focusTriggerElOnHide: $dropdownTriggerEl
        }), { type: 'DELETE' });

        function setDeleteButtonDisabled(disabled) {
            deleteRepositoryDialog.setConfirmButtonDisabled(disabled);
        }

        deleteRepositoryDialog.attachTo(deleteButtonSelector, function () {
            var $repoNameInput = (0, _jquery2.default)(deleteRepositoryDialog.getContentElement()).find('#confirmRepoName');

            if ($repoNameInput.val() !== repo.name) {
                setDeleteButtonDisabled(true);
            }

            $repoNameInput.on('input', function () {
                setDeleteButtonDisabled($repoNameInput.val() !== repo.name);
            });

            (0, _jquery2.default)('#delete-repository-dialog').on('submit', function (e) {
                return e.preventDefault();
            });
        });

        deleteRepositoryDialog.addConfirmListener(function (promise) {
            promise.then(function (data, status, xhr) {
                return server.poll({
                    url: (0, _jquery2.default)(deleteButtonSelector).attr('href'),
                    statusCode: {
                        404: function _() {
                            notifications.addFlash(null, {
                                body: _aui.I18n.getText('bitbucket.web.repository.deleted', repo.name)
                            });

                            window.location = nav.project(_state2.default.getProject()).build();

                            return false; // don't handle this globally.
                        }
                    }
                });
            });
        });

        deleteRepositoryDialog.addExtraListener(function (promise, $trigger, removeDialog, dialog, $extraButton) {
            $extraButton.busy();
            archiveRequest(repo, archived, removeDialog);
        });
    }

    function initSizes($field) {
        var $button = $field.find('.size-load-button');

        $button.click(function (e) {
            e.preventDefault();
            if (!$button.get(0).isBusy()) {
                getSizes($button, $field);
            }
        });
    }

    function getSizes($button, $field) {
        $button.get(0).busy();

        server.rest({
            type: 'GET',
            url: nav.repository(_state2.default.getRepository()).sizes().withParams({ forceCalculation: true }).build(),
            statusCode: { '*': false }
        }).always(function () {
            $button.remove();
        }).done(function (sizes) {
            $field.html(bitbucket.internal.page.repository.settings.general.repositorySettings.repositorySizeDisplay(sizes));
        }).fail(function () {
            var error = bitbucket.internal.page.repository.settings.general.repositorySettings.repositoryInlineError({
                message: _aui.I18n.getText('bitbucket.web.repository.size.error')
            });
            (0, _jquery2.default)(error).insertAfter($field);
        });
    }

    var initCancelButton = function initCancelButton() {
        (0, _jquery2.default)('.repository-edit-settings-cancel').on('click', function () {
            location.reload();
        });
    };

    var initPluginFields = function initPluginFields() {
        var repo = _pageState2.default.getRepository().toJSON();

        if (repo.archived) {
            // disable plugins inputs
            (0, _jquery2.default)('.stash-repository-edit-settings-form fieldset').prop('disabled', true).attr('aria-disabled', true);
        }
    };

    function initBranchSelector($branchSelector, $field) {
        var repo = _pageState2.default.getRepository().toJSON();

        if (repo.archived) {
            // disable branch selector plugin
            $branchSelector.prop('disabled', true).attr('aria-disabled', true);
        } else {
            new _branchSelector2.default($branchSelector, {
                ariaLabel: _aui.I18n.getText('bitbucket.web.repository.defaultbranch.update.html'),
                field: $field
            });
        }
    }

    function onReady(formSelector, moveButtonSelector, archiveButtonSelector, deleteButtonSelector, deleteDialogArchiveButtonSelector) {
        // Ensure that any flash notifications which are available are added to the page
        notifications.showFlashes();

        initMoveButton(moveButtonSelector);
        initArchiveButton(archiveButtonSelector);
        initDeleteButton(deleteButtonSelector, deleteDialogArchiveButtonSelector);
        initSizes((0, _jquery2.default)(formSelector).find('.field-group #size'));
        initCancelButton();

        initPluginFields();

        initBranchSelector((0, _jquery2.default)('#default-branch'), (0, _jquery2.default)('#default-branch-field'));

        var $repoName = (0, _jquery2.default)('#name');
        var $cloneUrl = (0, _jquery2.default)('.clone-url-generated span');

        _cloneUrlGen2.default.bindUrlGeneration($cloneUrl, {
            elementsToWatch: [$repoName],
            getRepoName: $repoName.val.bind($repoName)
        });
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});