define('bitbucket/internal/page/users/account/account', ['module', 'exports', 'jquery', 'bitbucket/internal/util/analytics', 'bitbucket/internal/widget/user-avatar-form/user-avatar-form'], function (module, exports, _jquery, _analytics, _userAvatarForm) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var analytics = _interopRequireWildcard(_analytics);

    var _userAvatarForm2 = _interopRequireDefault(_userAvatarForm);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function cleanErrors() {
        (0, _jquery2.default)('.user-avatar-error').remove();
    }

    function notifyError(message) {
        cleanErrors();
        (0, _jquery2.default)('.aui-page-panel-content > .aui-page-header').after(aui.message.error({
            content: message,
            extraClasses: 'user-avatar-error'
        }));
    }

    function sendAnalytics() {
        var ANALYTICS_CONST = 'stash.client.color.filter.user.changed';

        analytics.add(ANALYTICS_CONST, {
            filter: (0, _jquery2.default)('#colorFilter').val()
        });
    }

    function onReady(user, avatarContainerSelector) {
        var xsrfToken = {
            name: 'atl_token',
            value: (0, _jquery2.default)('.account-settings input[name=atl_token]').val()
        };

        var avatarForm = new _userAvatarForm2.default((0, _jquery2.default)(avatarContainerSelector), user, xsrfToken);
        avatarForm.on('avatarChanged', cleanErrors);
        avatarForm.on('avatarUploadError', notifyError);
        avatarForm.on('avatarDeleteError', notifyError);

        var settingsForm = (0, _jquery2.default)('.account-settings form');
        settingsForm.on('submit', sendAnalytics);
    }

    exports.default = {
        onReady: onReady
    };
    module.exports = exports['default'];
});