define('bitbucket/internal/page/users/profile/profile', ['exports', 'react', 'react-dom', 'react-redux', 'bitbucket/internal/enums', 'bitbucket/internal/feature/repository/filterable-repository-table/actions', 'bitbucket/internal/feature/repository/filterable-repository-table/filterable-repository-table', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/feature-enabled', 'bitbucket/internal/util/notifications/notifications', 'bitbucket/internal/widget/filterable-entity-table/entity-rest-actor', 'bitbucket/internal/widget/filterable-entity-table/filterable-entity-table', 'bitbucket/internal/widget/filterable-entity-table/store', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state'], function (exports, _react, _reactDom, _reactRedux, _enums, _actions, _filterableRepositoryTable, _analytics, _featureEnabled, _notifications, _entityRestActor, _filterableEntityTable, _store, _navbuilder, _server, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.init = init;

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    var _filterableRepositoryTable2 = _interopRequireDefault(_filterableRepositoryTable);

    var analytics = _interopRequireWildcard(_analytics);

    var notifications = _interopRequireWildcard(_notifications);

    var _store2 = _interopRequireDefault(_store);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var isRepositoryArchivingFeatureEnabled = (0, _featureEnabled.getFromProviderSync)('repository.archiving');

    var selectFilterKey = 'archived';

    // used to convert filter params to url params and vice versa
    var queryParamByFilterKey = {
        // select filter input
        selectFilter: selectFilterKey,
        // text filter input
        filter: 'filter'
    };

    var fallbackBuilder = function fallbackBuilder(_ref) {
        var _extends2;

        var filter = _ref.filter,
            _ref$selectFilter = _ref.selectFilter,
            selectFilter = _ref$selectFilter === undefined ? _enums.RepositoryType.ACTIVE : _ref$selectFilter;
        return nav.rest().allRepos().withParams(_extends((_extends2 = {
            projectkey: _state2.default.getProject().key
        }, _defineProperty(_extends2, selectFilterKey, selectFilter), _defineProperty(_extends2, 'avatarSize', _enums.AvatarSize.SMALL), _extends2), filter && { name: filter }));
    };

    var urlBuilder = function urlBuilder(_ref2) {
        var filter = _ref2.filter,
            selectFilter = _ref2.selectFilter;

        // only use `search` endpoint if search input field is updated
        if (filter) {
            return nav.rest('search').project(_state2.default.getProject()).allRepos().withParams(_extends(_defineProperty({}, selectFilterKey, selectFilter), filter && { filter: filter }, {
                avatarSize: _enums.AvatarSize.SMALL
            }));
        }

        // fetch repos from db if only archive dropdown is updated
        return fallbackBuilder({ filter: filter, selectFilter: selectFilter });
    };

    var bindCreateAnalytics = function bindCreateAnalytics(el, isEmptyState) {
        return el && el.addEventListener('click', function () {
            analytics.add('profile-repository-list.create.clicked', {
                'is.empty.state': !!isEmptyState
            });
        });
    };

    function init(el, _ref3) {
        var repositoryPage = _ref3.repositoryPage;

        notifications.showFlashes();

        bindCreateAnalytics(document.querySelector('.aui-page-header-actions .create-repository-button'));

        bindCreateAnalytics(document.querySelector('.welcome-mat .create-repository-button'), true);

        if (repositoryPage && !repositoryPage.size && repositoryPage.isLastPage) {
            //If we have a initial page from the server, and it's empty and is the last page, don't initialise the repo table
            return;
        }

        var entityName = _enums.Entity.REPOSITORY;
        var loadAction = _actions.LOAD_REPOSITORIES;

        // get filters from the URL params
        var initialFilter = (0, _filterableRepositoryTable.filterFromUrlParams)(queryParamByFilterKey);
        // if no type present default should be active
        if (!initialFilter.selectFilter) initialFilter.selectFilter = _enums.RepositoryType.ACTIVE;

        var store = (0, _store2.default)({
            actors: [(0, _entityRestActor.loadEntitiesRestActor)({
                loadAction: loadAction,
                urlBuilder: urlBuilder,
                statusCode: {
                    401: _server.createEmptyPage
                },
                fallbackBuilder: fallbackBuilder,
                responseTransformer: (0, _entityRestActor.searchResponseTransformer)(entityName)
            })],
            entityName: entityName,
            loadAction: loadAction,
            initialFilter: initialFilter
        });

        var ConnectedTable = (0, _filterableEntityTable.connectEntityTable)(entityName, loadAction, _filterableRepositoryTable2.default);
        // profile page includes a header that pushes the footer away
        var bufferPx = document.getElementById('footer').getBoundingClientRect().height + document.querySelector('.aui-page-header').getBoundingClientRect().height;

        _reactDom2.default.render(_react2.default.createElement(
            _reactRedux.Provider,
            { store: store },
            _react2.default.createElement(ConnectedTable, {
                bufferPx: bufferPx,
                onRepoClick: function onRepoClick(repository, filter, repositories) {
                    analytics.add('profile-repository-list.item.clicked', {
                        'filter.length': filter.length,
                        'project.id': repository.project.id,
                        'repository.id': repository.id,
                        'result.index': repositories.indexOf(repository),
                        'results.size': repositories.length
                    });
                },
                onSelectFilterChange: function onSelectFilterChange(filters) {
                    analytics.add('stash.repository.searched', {
                        archived: filters.selectFilter,
                        page: 'profile'
                    });
                    (0, _filterableRepositoryTable.updateUrlWithFilterParams)(queryParamByFilterKey, filters);
                },
                filterable: true,
                filterVisible: true,
                showArchivedLozenge: true,
                showSelectFilter: isRepositoryArchivingFeatureEnabled,
                refreshOnFilterReset: true,
                showEmptyStateWithFilter: true
            })
        ), el);
    }
});