define('bitbucket/internal/util/__mocks__/property', ['module', 'exports'], function (module, exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    var defaultPropertyValuesMap = {
        'attachment.upload.max.size': 10485760,
        'display.max.jupyter.notebook.size': 2097152,
        'display.max.source.lines': 20000,
        'git.pull-request.merge.timeout': 300,
        'git.pull-request.rebase.timeout': 30,
        'page.max.changes': 1000,
        'page.max.diff.lines': 10000,
        'page.max.source.lines': 20000,
        'pullrequest.diff.context': 10,
        'pullrequest.diff.context.expand.size': 25,
        'content.upload.max.size': 5242880, // 5MB max size of upload for a commit (source editor)
        'plugin.multiline.comment.max.span.size': 30,
        'display.max.syntax.highlighted.source.lines': 200000
    };

    exports.default = {
        getFromProviderSync: function getFromProviderSync(key) {
            return defaultPropertyValuesMap[key];
        }
    };
    module.exports = exports['default'];
});