define('bitbucket/internal/util/ajax', ['exports', 'bitbucket/internal/util/form', 'lodash', 'bitbucket/internal/util/error', 'bitbucket/util/server'], function (exports, _form, _lodash, _error, _server) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._getHeaders = exports.poll = exports.rest = exports.ajax = exports.formToJSON = undefined;
    Object.defineProperty(exports, 'formToJSON', {
        enumerable: true,
        get: function () {
            return _form.formToJSON;
        }
    });
    exports.ignore404WithinRepository = ignore404WithinRepository;

    var _error2 = _interopRequireDefault(_error);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function ignore404WithinRepository(callback) {
        return {
            404: function _(xhr, testStatus, errorThrown, data, fallbackError) {
                var error = (0, _lodash.get)(data, 'errors.0');

                if (_error2.default.isErrorEntityWithinRepository(error)) {
                    return callback && callback(data) || false; // don't handle this globally.
                }
            }
        };
    }

    exports.ajax = _server.ajax;
    exports.rest = _server.rest;
    exports.poll = _server.poll;
    exports._getHeaders = _server._getHeaders;
});