define('bitbucket/internal/util/commit', ['exports', '@atlassian/aui', 'bitbucket/internal/util/time', 'bitbucket/internal/util/user', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state'], function (exports, _aui, _time, _user, _navbuilder, _server, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.addCommitterTooltip = exports.addAuthorTooltip = undefined;
    exports.create = create;

    var timeUtils = _interopRequireWildcard(_time);

    var nav = _interopRequireWildcard(_navbuilder);

    var server = _interopRequireWildcard(_server);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    /**
     * Returns a promise with the results from the create commit API call
     * @param {string} sourceBranch - existing branch the user is starting from
     * @param {string} sourceCommitId - the commitId for the previous state of the content (when the content was loaded).
     * @param {string} branch - branch to commit to (can be the same as the source branch)
     * @param {string} message - commit message
     * @param {string} content - encoded entire file
     * @param {string|array} filePath - path to the file to commit
     * @param {object} handledStatusCodes - an object mapping a HTTP status code to an error handling function
     *                                      (see 'bitbucket/util/server')
     * @param {object} [options={}] additional information to pass to server.rest
     */
    function create(_ref) {
        var _nav$rest$repository$;

        var sourceBranch = _ref.sourceBranch,
            sourceCommitId = _ref.sourceCommitId,
            branch = _ref.branch,
            message = _ref.message,
            content = _ref.content,
            filePath = _ref.filePath,
            handledStatusCodes = _ref.handledStatusCodes;

        if (typeof filePath === 'string') {
            filePath = filePath.split('/');
        }
        handledStatusCodes = handledStatusCodes.reduce(function (hash, code) {
            hash[code] = false;

            return hash;
        }, {});

        // Note: you must do data.append() on each line (no chaining) as append doesn't return the data obj.
        var data = new FormData();
        data.append('sourceBranch', sourceBranch);
        data.append('sourceCommitId', sourceCommitId);
        data.append('branch', branch);
        data.append('message', message);
        data.append('content', content);

        var url = (_nav$rest$repository$ = nav.rest().repository(_state2.default.getRepository()).browse()).addPathComponents.apply(_nav$rest$repository$, _toConsumableArray(filePath)).withParams({
            avatarSize: bitbucket.internal.widget.avatar.avatar.avatarSizeInPx({
                size: 'large'
            })
        }).build();

        return server.rest({
            url: url,
            data: data,
            type: 'PUT',
            processData: false,
            contentType: false,
            statusCode: handledStatusCodes
        });
    }

    var addAuthorTooltip = exports.addAuthorTooltip = function addAuthorTooltip($el, author, authorTimestamp) {
        $el.tooltip({
            title: function title() {
                return _aui.I18n.getText('bitbucket.web.commit.pullrequest.authored', (0, _user.getUserDisplayName)(author), timeUtils.format(authorTimestamp, 'short'));
            },
            gravity: 'nw'
        });
    };

    var addCommitterTooltip = exports.addCommitterTooltip = function addCommitterTooltip($el, committer, committerTimestamp) {
        $el.tooltip({
            title: function title() {
                return _aui.I18n.getText('bitbucket.web.commit.pullrequest.committed', (0, _user.getUserDisplayName)(committer), timeUtils.format(committerTimestamp, 'short'));
            },
            gravity: 'nw'
        });
    };
});