define('bitbucket/internal/util/copy-to-clipboard', ['exports'], function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.copyToClipboard = copyToClipboard;
    function fallbackCopyToClipboard(text) {
        if (window.clipboardData && window.clipboardData.setData) {
            // Internet Explorer-specific code path to prevent textarea being shown while dialog is visible.
            window.clipboardData.setData('Text', text);

            return true;
        } else {
            var textarea = document.createElement('textarea');
            textarea.textContent = text;
            textarea.style.position = 'fixed'; // Prevent scrolling to bottom of page in Microsoft Edge.
            document.body.appendChild(textarea);
            textarea.select();

            try {
                document.execCommand('copy'); // Security exception may be thrown by some browsers.

                return true;
            } catch (err) {
                return false;
            } finally {
                document.body.removeChild(textarea);
            }
        }
    }

    // navigator.clipboard is only available to Secure Contexts, either HTTPS or localhost.
    function copyToClipboard(text) {
        if (window.isSecureContext && navigator.clipboard) {
            navigator.clipboard.writeText(text);

            return true;
        } else {
            return fallbackCopyToClipboard(text);
        }
    }
});