define('bitbucket/internal/util/emacs', ['module', 'exports', 'codemirror', 'bitbucket/internal/util/navigator'], function (module, exports, _codemirror, _navigator) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _codemirror2 = _interopRequireDefault(_codemirror);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var emacKeyMapSubset = ['Ctrl-K', 'Ctrl-Y'];

    // emacs is not included in codemirror by default, in case it isn't available these keybondings will be ignored
    function keyMapSubset() {
        var codemirrorEmacKeyMap = _codemirror2.default.keyMap.emacs || {};
        var emacKeyMap = {};

        if (!(0, _navigator.isMac)()) {
            return emacKeyMap;
        }

        for (var key in codemirrorEmacKeyMap) {
            if (emacKeyMapSubset.includes(key)) {
                emacKeyMap[key] = codemirrorEmacKeyMap[key];
            }
        }

        return emacKeyMap;
    }

    var EMAC_KEY_MAP = keyMapSubset();

    exports.default = EMAC_KEY_MAP;
    module.exports = exports['default'];
});