define('bitbucket/internal/util/enforce-project-settings/util', ['exports', '@atlassian/aui', 'bitbucket/internal/util/feature-enabled', 'bitbucket/util/navbuilder', 'bitbucket/util/server'], function (exports, _aui, _featureEnabled, _navbuilder, _server) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.saveProjectLockSettings = exports.fetchAllRestrictions = exports.fetchRestriction = exports.isRestrictionProcessing = exports.isRestrictionPresent = exports.isProjectSettingRestricted = exports.ProjectSettingsRestrictionAction = exports.RestrictionProcessingStates = exports.RESTRICTION_POLLING_INTERVAL_MILLISECONDS = exports.PROJECT_LOCK_OPTIONS = exports.ProjectLockOptions = exports.FeatureKeys = exports.namespace = exports.isEnforceProjectSettingsEnabled = undefined;

    var nav = _interopRequireWildcard(_navbuilder);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _objectWithoutProperties(obj, keys) {
        var target = {};

        for (var i in obj) {
            if (keys.indexOf(i) >= 0) continue;
            if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
            target[i] = obj[i];
        }

        return target;
    }

    var isEnforceProjectSettingsEnabled = exports.isEnforceProjectSettingsEnabled = (0, _featureEnabled.getFromProviderSync)('enforce.project.settings');

    // TODO:: this will be updated with BBSDEV-26765
    var namespace = exports.namespace = 'com.atlassian.bitbucket.server:internal';
    var FeatureKeys = exports.FeatureKeys = Object.freeze({
        ACCESS_TOKENS: 'http-access-tokens',
        ACCESS_KEYS: 'ssh-access-keys',
        AUTO_MERGE: 'auto-merge',
        BRANCH_MODEL: 'branch-model',
        EFFECTIVE_PERMISSIONS: 'repository-permissions',
        HOOKS: 'hooks',
        MERGE_STRATEGIES: 'merge-strategies',
        MERGE_QUEUE: 'merge-queue'
    });

    // required for dropdown on project settings
    var ProjectLockOptions = exports.ProjectLockOptions = Object.freeze({
        LOCKED: 'LOCKED',
        PROCESSED: 'PROCESSED',
        UNLOCKED: 'UNLOCKED'
    });

    var PROJECT_LOCK_OPTIONS = exports.PROJECT_LOCK_OPTIONS = [ProjectLockOptions.LOCKED, ProjectLockOptions.UNLOCKED];
    var RESTRICTION_POLLING_INTERVAL_MILLISECONDS = exports.RESTRICTION_POLLING_INTERVAL_MILLISECONDS = 2000;

    /**
     * Processing states for diff component keys in merge hooks & checks
     * @enum {string}
     */
    var RestrictionProcessingStates = exports.RestrictionProcessingStates = Object.freeze({
        // no restriction
        NONE: 'NONE',
        // processing restriction - all other actions are disabled
        RESTRICTED_UNMODIFIABLE: 'RESTRICTED_UNMODIFIABLE',
        UNPROCESSED: 'UNPROCESSED',
        // used to display saving label only
        PROCESSING: 'PROCESSING',
        // restriction is present
        RESTRICTED_MODIFIABLE: 'RESTRICTED_MODIFIABLE',
        PROCESSED: 'PROCESSED',
        FAILED: 'FAILED',
        IN_PROGRESS: 'IN_PROGRESS'
    });

    /**
     * Actions to be executed during a restriction update request
     * @enum {string}
     */
    var ProjectSettingsRestrictionAction = exports.ProjectSettingsRestrictionAction = Object.freeze({
        CREATE: 'CREATE',
        DELETE: 'DELETE',
        NONE: 'NONE'
    });

    var isProjectSettingRestricted = exports.isProjectSettingRestricted = function isProjectSettingRestricted(restrictionState) {
        switch (restrictionState) {
            case RestrictionProcessingStates.RESTRICTED_MODIFIABLE:
            case RestrictionProcessingStates.PROCESSED:
            case RestrictionProcessingStates.FAILED:
                return true;
            default:
                return false;
        }
    };

    var isRestrictionPresent = exports.isRestrictionPresent = function isRestrictionPresent(restrictionState) {
        return restrictionState !== RestrictionProcessingStates.NONE;
    };

    var isRestrictionProcessing = exports.isRestrictionProcessing = function isRestrictionProcessing(restrictionState) {
        switch (restrictionState) {
            case RestrictionProcessingStates.RESTRICTED_UNMODIFIABLE:
            case RestrictionProcessingStates.UNPROCESSED:
            case RestrictionProcessingStates.IN_PROGRESS:
            case RestrictionProcessingStates.PROCESSING:
                return true;
            default:
                return false;
        }
    };

    /**
     * Data provider
     */
    var settingsPathComponent = 'settings-restriction';

    var urlBuilder = nav.rest();

    var toNativePromise = function toNativePromise(thenable) {
        return new Promise(function (resolve, reject) {
            thenable.then(resolve, reject);
        });
    };

    var getRestUrlBuilder = function getRestUrlBuilder(project) {
        return urlBuilder.project(project).addPathComponents(settingsPathComponent);
    };

    var unResponsiveStatusCode = {
        // handle unresponsive network
        title: _aui.I18n.getText('bitbucket.web.server.unreachable.title'),
        message: _aui.I18n.getText('bitbucket.web.error.server.unresponsive'),
        shouldReload: true
    };

    // api to delete the ProjectSettingsRestriction
    var deleteRestriction = function deleteRestriction(_ref) {
        var project = _ref.project,
            featureKey = _ref.featureKey,
            componentKey = _ref.componentKey;

        var url = getRestUrlBuilder(project).withDefinedParams({
            namespace: namespace,
            featureKey: featureKey,
            componentKey: componentKey
        }).build();

        return toNativePromise((0, _server.rest)({
            url: url,
            type: _server.method.DELETE
        }));
    };

    var createRestriction = function createRestriction(_ref2) {
        var project = _ref2.project,
            featureKey = _ref2.featureKey,
            componentKey = _ref2.componentKey;

        var url = getRestUrlBuilder(project).build();

        return toNativePromise((0, _server.rest)({
            url: url,
            data: {
                namespace: namespace,
                featureKey: featureKey,
                componentKey: componentKey
            },
            type: _server.method.POST,
            statusCode: {
                // restriction is already present
                409: false
            }
        }));
    };

    var fetchRestriction = exports.fetchRestriction = function fetchRestriction(_ref3) {
        var project = _ref3.project,
            featureKey = _ref3.featureKey,
            componentKey = _ref3.componentKey;

        var url = getRestUrlBuilder(project).withDefinedParams({
            namespace: namespace,
            featureKey: featureKey,
            componentKey: componentKey
        }).build();

        return toNativePromise((0, _server.rest)({
            url: url,
            statusCode: {
                0: unResponsiveStatusCode,
                // if restriction is not present
                404: false
            }
        }));
    };

    // given a featureKey, fetch all components' restriction, e.g. hooks
    var fetchAllRestrictions = exports.fetchAllRestrictions = function fetchAllRestrictions(_ref4) {
        var project = _ref4.project,
            featureKey = _ref4.featureKey;

        var url = getRestUrlBuilder(project).addPathComponents('all').withDefinedParams({
            namespace: namespace,
            featureKey: featureKey
        }).build();

        return toNativePromise((0, _server.rest)({
            url: url,
            statusCode: {
                0: unResponsiveStatusCode,
                // if restriction is not present
                404: false
            }
        }));
    };

    var saveProjectLockSettings = function saveProjectLockSettings(_ref5) {
        var isLocked = _ref5.isLocked,
            rest = _objectWithoutProperties(_ref5, ['isLocked']);

        if (isLocked) return createRestriction(rest);

        return deleteRestriction(rest);
    };
    exports.saveProjectLockSettings = saveProjectLockSettings;
});