define('bitbucket/internal/util/entity', ['exports'], function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    var getCommitId = exports.getCommitId = function getCommitId(commit) {
        return commit.id;
    };
    var getProjectId = exports.getProjectId = function getProjectId(project) {
        return project.key;
    };
    var getPullRequestId = exports.getPullRequestId = function getPullRequestId(pullRequest) {
        var repo = pullRequest.toRef.repository;

        return [repo.project.key, repo.slug, pullRequest.id].join('/');
    };
    var getRepositoryId = exports.getRepositoryId = function getRepositoryId(repo) {
        return [repo.project.key, repo.slug].join('/');
    };
    var getUserId = exports.getUserId = function getUserId(user) {
        return user.slug;
    };

    var buildMinimalCommit = exports.buildMinimalCommit = function buildMinimalCommit(id) {
        return { id: id };
    };
    var buildMinimalProject = exports.buildMinimalProject = function buildMinimalProject(key) {
        return { key: key };
    };
    var buildMinimalPullRequest = exports.buildMinimalPullRequest = function buildMinimalPullRequest(key, slug, id) {
        return {
            toRef: { repository: buildMinimalRepository(key, slug) },
            id: id
        };
    };
    var buildMinimalRepository = exports.buildMinimalRepository = function buildMinimalRepository(key, slug) {
        return {
            project: buildMinimalProject(key),
            slug: slug
        };
    };
    var buildMinimalUser = exports.buildMinimalUser = function buildMinimalUser(slug) {
        return { slug: slug };
    };
});