define('bitbucket/internal/util/feature-enabled', ['exports', 'jquery', 'bitbucket/internal/util/wrm'], function (exports, _jquery, _wrm) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.getFromProviderSync = getFromProviderSync;
    exports.getFromProvider = getFromProvider;

    var _jquery2 = _interopRequireDefault(_jquery);

    var _wrm2 = _interopRequireDefault(_wrm);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /**
     * Use with the feature-wrm-data.xml plugin
     * @since 3.1
     */
    var cache = {};
    var has = Object.prototype.hasOwnProperty;

    function getFromProviderSync(key) {
        return has.call(cache, key) ? cache[key] : cache[key] = _wrm2.default.data.claim('com.atlassian.bitbucket.server.feature-wrm-data:' + key + '.data');
    }

    function getFromProvider(key) {
        return _jquery2.default.Deferred().resolve(getFromProviderSync(key));
    }
});