define('bitbucket/internal/util/hooks/use-focus-on-render', ['exports', 'react'], function (exports, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.useFocusOnRender = undefined;


    /**
     * focus browser on the element after each time component renders
     *
     * @param {React.RefObject} elementRef          The instance of react reference
     * @param {Element}         elementRef.current  DOM element
     */
    var useFocusOnRender = exports.useFocusOnRender = function useFocusOnRender(elementRef) {
        return (0, _react.useEffect)(function () {
            var node = elementRef.current;


            if (node && document.activeElement !== node) {
                node.focus();
            }
        });
    };
});