define('bitbucket/internal/util/hooks/use-interval', ['module', 'exports', 'react'], function (module, exports, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.default = useInterval;
    function useInterval(callback, delay) {
        var savedCallback = (0, _react.useRef)();

        (0, _react.useEffect)(function () {
            savedCallback.current = callback;
        });

        (0, _react.useEffect)(function () {
            var id = setInterval(function () {
                savedCallback.current();
            }, delay);

            return function () {
                clearInterval(id);
            };
        }, [delay]);
    }
    module.exports = exports['default'];
});