define('bitbucket/internal/util/hooks/use-is-scrolling', ['module', 'exports', 'lodash', 'react'], function (module, exports, _lodash, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.default = useIsScrolling;

    var _slicedToArray = function () {
        function sliceIterator(arr, i) {
            var _arr = [];
            var _n = true;
            var _d = false;
            var _e = undefined;

            try {
                for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
                    _arr.push(_s.value);

                    if (i && _arr.length === i) break;
                }
            } catch (err) {
                _d = true;
                _e = err;
            } finally {
                try {
                    if (!_n && _i["return"]) _i["return"]();
                } finally {
                    if (_d) throw _e;
                }
            }

            return _arr;
        }

        return function (arr, i) {
            if (Array.isArray(arr)) {
                return arr;
            } else if (Symbol.iterator in Object(arr)) {
                return sliceIterator(arr, i);
            } else {
                throw new TypeError("Invalid attempt to destructure non-iterable instance");
            }
        };
    }();

    function useIsScrolling() {
        var wait = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 250;

        var _useState = (0, _react.useState)(false),
            _useState2 = _slicedToArray(_useState, 2),
            isScrolling = _useState2[0],
            setIsScrolling = _useState2[1];

        (0, _react.useEffect)(function () {
            var throttledHandler = (0, _lodash.throttle)(function () {
                setIsScrolling(function (oldIsScrolling) {
                    return !oldIsScrolling ? true : oldIsScrolling;
                });
            });

            var debouncedHandler = (0, _lodash.debounce)(function () {
                setIsScrolling(false);
            }, wait);

            document.addEventListener('scroll', throttledHandler);
            document.addEventListener('resize', throttledHandler);

            document.addEventListener('scroll', debouncedHandler);
            document.addEventListener('resize', debouncedHandler);

            return function () {
                debouncedHandler.cancel();
                throttledHandler.cancel();

                document.removeEventListener('scroll', throttledHandler);
                document.removeEventListener('resize', throttledHandler);

                document.removeEventListener('scroll', debouncedHandler);
                document.removeEventListener('resize', debouncedHandler);
            };
            // eslint-disable-next-line react-hooks/exhaustive-deps
        }, []);

        return isScrolling;
    }
    module.exports = exports['default'];
});