define('bitbucket/internal/util/hooks/use-lazy-entity', ['exports', 'react', 'react-redux', 'bitbucket/internal/util/store/pull-request'], function (exports, _react, _reactRedux, _pullRequest) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.useLazyPullRequest = exports.useLazyEntity = undefined;


    var nullSelector = function nullSelector() {
        return null;
    };
    var falseSelector = function falseSelector() {
        return false;
    };

    /**
     * Load an entity from the server if required, otherwise return from the store
     * @param {object} storeMethods
     * @param {function} storeMethods.getEntity - Selector to get the entity from the store
     * @param {function} storeMethods.getEntityLoading - Selector to get the loading state when requesting the entity from the server
     * @param {function} storeMethods.loadEntity - Action creator to load the entity from the server
     * @param {object} minimalEntity - A stripped down version of the entity which has the key attributes in the right shape
     *                               - see bitbucket/internal/util/entity.js
     * @returns {[object, boolean]}
     */
    var useLazyEntity = exports.useLazyEntity = function useLazyEntity(_ref, minimalEntity) {
        var getEntity = _ref.getEntity,
            getEntityLoading = _ref.getEntityLoading,
            loadEntity = _ref.loadEntity;

        var minimalEntitySelector = function minimalEntitySelector() {
            return minimalEntity;
        };
        var entity = (0, _reactRedux.useSelector)(minimalEntity ? getEntity(minimalEntitySelector) : nullSelector);
        var entityLoading = (0, _reactRedux.useSelector)(minimalEntity ? getEntityLoading(minimalEntitySelector) : falseSelector);

        var dispatch = (0, _reactRedux.useDispatch)();

        (0, _react.useEffect)(function () {
            if (minimalEntity && !entity && !entityLoading) {
                dispatch(loadEntity(minimalEntity));
            }
            // eslint-disable-next-line react-hooks/exhaustive-deps
        }, [minimalEntity]);

        return [entity, entityLoading];
    };

    var useLazyPullRequest = exports.useLazyPullRequest = function useLazyPullRequest(minimalEntity) {
        return useLazyEntity({
            getEntity: _pullRequest.selectors.getPullRequest,
            getEntityLoading: _pullRequest.selectors.getPullRequestLoading,
            loadEntity: _pullRequest.actionCreators.loadPullRequest
        }, minimalEntity);
    };
});