define('bitbucket/internal/util/hooks/use-scroll-to-element-once', ['exports', 'react', 'scroll-into-view-if-needed'], function (exports, _react, _scrollIntoViewIfNeeded) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.useScrollToElementOnce = exports.SCROLL_TO_ELEMENT_MODAL_CLOSE_EVENT = exports.SCROLL_AND_CENTER = undefined;

    var _scrollIntoViewIfNeeded2 = _interopRequireDefault(_scrollIntoViewIfNeeded);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var SCROLL_AND_CENTER = exports.SCROLL_AND_CENTER = {
        block: 'center',
        scrollMode: 'always'
    };

    var SCROLL_TO_ELEMENT_MODAL_CLOSE_EVENT = exports.SCROLL_TO_ELEMENT_MODAL_CLOSE_EVENT = 'ScrollToElementModalCloseEvent';

    /**
     * Scrolls browser viewport into element after first component render
     *
     * @param {RefObject}   elementRef          The instance of react reference
     * @param {Element}     elementRef.current  DOM element
     * @param {Boolean}     [shouldScroll]      Should browser scroll into element
     * @param {Object}      [params]            Configuration overrides for scrollIntoView function
     * @return {void}
     */
    var useScrollToElementOnce = exports.useScrollToElementOnce = function useScrollToElementOnce(elementRef) {
        var shouldScroll = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
        var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

        (0, _react.useEffect)(function () {
            if (!shouldScroll) {
                return;
            }

            var scrollToElementWithAnimation = function scrollToElementWithAnimation() {
                // delay the scrolling into view to allow promises
                // to resolve and other race conditions goodness (e.g. BBSDEV-21326)
                requestAnimationFrame(function () {
                    // The reference object might get stale so we should check it before calling the 'scrollIntoView'
                    if (!(elementRef.current instanceof HTMLElement)) {
                        return;
                    }

                    (0, _scrollIntoViewIfNeeded2.default)(elementRef.current, _extends({
                        behavior: 'smooth',
                        scrollMode: 'if-needed',
                        block: 'nearest',
                        inline: 'nearest'
                    }, params));
                });
            };

            scrollToElementWithAnimation();

            // BSERV-19718: Page doesn't scroll when an Atlaskit modal is open due to its scroll lock.
            // Re-trigger scrolling once the user closes the Atlaskit modal.
            var handleModalClose = function handleModalClose() {
                // A 500ms delay ensures the scroll lock is fully removed after closing the Atlaskit modal before re-triggering scrolling.
                // Once DSP-13917 is resolved, we can dispatch the modal close event on `onCloseComplete` and remove this delay.
                setTimeout(function () {
                    scrollToElementWithAnimation();
                    // Remove the event listener after it executes once
                    window.removeEventListener(SCROLL_TO_ELEMENT_MODAL_CLOSE_EVENT, handleModalClose);
                }, 500);
            };

            window.addEventListener(SCROLL_TO_ELEMENT_MODAL_CLOSE_EVENT, handleModalClose);

            return function () {
                window.removeEventListener(SCROLL_TO_ELEMENT_MODAL_CLOSE_EVENT, handleModalClose);
            };
            // eslint-disable-next-line react-hooks/exhaustive-deps
        }, [shouldScroll]);
    };
});