define('bitbucket/internal/util/locale', ['exports'], function (exports) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    var getDocumentLocale = exports.getDocumentLocale = function getDocumentLocale() {
        return document.documentElement.lang || 'en';
    };

    var getBrowserLocale = exports.getBrowserLocale = function getBrowserLocale() {
        if (navigator.languages !== undefined) {
            return navigator.languages[0];
        }

        return navigator.language || getDocumentLocale();
    };

    /**
     * Get localized date format string, e.g. "mm/dd/yyyy".
     * Useful for making hints for screen reader users, specifically for date pickers.
     *
     * @param {string} locale browser locale
     * @returns date format string, e.g. "mm/dd/yyyy"
     */
    var getDateFormatStringByLocale = exports.getDateFormatStringByLocale = function getDateFormatStringByLocale(locale) {
        var sampleDate = new Date(1999, 1, 1);
        var formatParts = new Intl.DateTimeFormat(locale).formatToParts(sampleDate);

        var formatPartsValues = [];
        formatParts.forEach(function (part) {
            var val = part.value;

            if (part.type === 'day') {
                val = val.replace(/[0-9]/g, 'd');
            } else if (part.type === 'month') {
                val = val.replace(/[0-9]/g, 'm');
            } else if (part.type === 'year') {
                val = val.replace(/[0-9]/g, 'y');
            }

            formatPartsValues.push(val);
        });

        return formatPartsValues.join('');
    };
});