define('bitbucket/internal/util/property', ['exports', 'jquery', 'bitbucket/internal/util/wrm'], function (exports, _jquery, _wrm) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._resetCache = exports._coerce = undefined;
    exports.getFromProvider = getFromProvider;

    var _jquery2 = _interopRequireDefault(_jquery);

    var _wrm2 = _interopRequireDefault(_wrm);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /**
     * Use with the config-wrm-data.xml plugin
     * @since 3.1
     */
    function coerce(value, type) {
        if (value == null) {
            return value;
        }

        switch (type) {
            case 'STRING':
                return value;
            case 'NUMBER':
                return Number(value);
            case 'BOOLEAN':
                return value.toLowerCase() === 'true';
        }
    }

    var cache = {};

    var resetCache = function resetCache() {
        cache = {};
    };

    function getFromProviderSync(key) {
        var data = cache.hasOwnProperty(key) ? cache[key] : cache[key] = _wrm2.default.data.claim('com.atlassian.bitbucket.server.config-wrm-data:' + key + '.data');

        if (data) {
            return coerce(data.value, data.type);
        }

        return null;
    }

    function getFromProvider(key) {
        var data = getFromProviderSync(key);

        return data != null ? _jquery2.default.Deferred().resolve(data) : _jquery2.default.Deferred().reject();
    }

    // Visible for testing
    exports._coerce = coerce;
    exports._resetCache = resetCache;
    exports.default = {
        getFromProvider: getFromProvider,
        getFromProviderSync: getFromProviderSync,
        // Visible for testing
        _coerce: coerce,
        _resetCache: resetCache
    };
});