define('bitbucket/internal/util/ref-matcher', ['exports', '@bitbucket/widget/ref-selector/enum', '../enums'], function (exports, _enum, _enums) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.fromAPIRefMatch = exports.toAPIRefMatch = undefined;
    var NONE = _enums.BranchPatternType.NONE,
        ALL_BRANCHES = _enums.BranchPatternType.ALL_BRANCHES,
        BRANCHING_MODEL = _enums.BranchPatternType.BRANCHING_MODEL,
        BRANCHING_MODEL_BRANCH = _enums.BranchPatternType.BRANCHING_MODEL_BRANCH,
        BRANCHING_MODEL_CATEGORY = _enums.BranchPatternType.BRANCHING_MODEL_CATEGORY,
        BRANCH_PATTERN = _enums.BranchPatternType.BRANCH_PATTERN,
        BRANCH_NAME = _enums.BranchPatternType.BRANCH_NAME;


    var makeToRefMatch = function makeToRefMatch(pattern, type) {
        return { id: pattern, type: { id: type } };
    };

    var toAPIRefMatch = exports.toAPIRefMatch = function toAPIRefMatch(_ref) {
        var type = _ref.type,
            pattern = _ref.pattern;
        var scope = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _enums.ScopeType.REPOSITORY;

        switch (type) {
            case NONE:
                return null;
            case ALL_BRANCHES:
                return makeToRefMatch('ANY_REF_MATCHER_ID', type);
            case BRANCHING_MODEL:
                if (pattern.branch != null || pattern.type === _enum.RefSelectorType.BRANCH) {
                    return makeToRefMatch(pattern.id, BRANCHING_MODEL_BRANCH);
                } else {
                    return makeToRefMatch(pattern.id, BRANCHING_MODEL_CATEGORY);
                }
            case BRANCH_PATTERN:
                return makeToRefMatch(pattern, type);
            case BRANCH_NAME:
                return scope === _enums.ScopeType.REPOSITORY ? makeToRefMatch(pattern.id, type) : makeToRefMatch(pattern, type);
        }
    };

    var makeFromRefMatch = function makeFromRefMatch(pattern, type) {
        return { type: type, pattern: pattern };
    };

    var fromAPIRefMatch = exports.fromAPIRefMatch = function fromAPIRefMatch(refMatch) {
        if (!refMatch) {
            return makeFromRefMatch(null, NONE);
        }

        var id = refMatch.id,
            displayId = refMatch.displayId,
            type = refMatch.type;


        switch (type.id) {
            case ALL_BRANCHES:
                return makeFromRefMatch(null, ALL_BRANCHES);
            case BRANCHING_MODEL_CATEGORY:
                return makeFromRefMatch({ id: id, displayId: displayId }, BRANCHING_MODEL);
            case BRANCHING_MODEL_BRANCH:
                return makeFromRefMatch({ id: id, displayId: displayId, type: _enum.RefSelectorType.BRANCH }, BRANCHING_MODEL);
            case BRANCH_PATTERN:
                return makeFromRefMatch(id, BRANCH_PATTERN);
            case BRANCH_NAME:
                return makeFromRefMatch({ id: id, displayId: displayId, value: id }, BRANCH_NAME);
        }
    };
});