define('bitbucket/internal/util/rest-actor/requests-registry', ['exports', 'bitbucket/util/server'], function (exports, _server) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.createRequestsRegistry = createRequestsRegistry;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var DEFAULT_NAMESPACE = Symbol('DEFAULT_NAMESPACE');

    /**
     * Check if current request config looks like regular rest transport
     *
     * @param requestConfig
     * @return {boolean}
     */
    var isRestLikeTransport = function isRestLikeTransport(requestConfig) {
        return Boolean(requestConfig.url && requestConfig.type);
    };

    /**
     * Get namespaced registry
     *
     * @param registry {object}
     * @param requestConfig {object}
     * @return {Map}
     */
    var getNamespacedRegistry = function getNamespacedRegistry(registry, requestConfig) {
        var key = isRestLikeTransport(requestConfig) ? requestConfig.type : DEFAULT_NAMESPACE;

        return registry[key] || registry[DEFAULT_NAMESPACE];
    };

    /**
     * Gets deterministic key from a request config
     *
     * @param requestConfig
     * @return {string}
     */
    var getRequestKey = function getRequestKey(requestConfig) {
        return isRestLikeTransport(requestConfig) ? requestConfig.url : JSON.stringify(requestConfig);
    };

    function createRequestsRegistry() {
        var _registry;

        var registry = (_registry = {}, _defineProperty(_registry, _server.method.DELETE, new Map()), _defineProperty(_registry, _server.method.GET, new Map()), _defineProperty(_registry, _server.method.PATCH, new Map()), _defineProperty(_registry, _server.method.POST, new Map()), _defineProperty(_registry, _server.method.PUT, new Map()), _defineProperty(_registry, DEFAULT_NAMESPACE, new Map()), _registry);

        return {
            store: function store(requestConfig, request) {
                var localRegistry = getNamespacedRegistry(registry, requestConfig);
                var requestKey = getRequestKey(requestConfig);

                localRegistry.set(requestKey, request);
            },
            get: function get(requestConfig) {
                var localRegistry = getNamespacedRegistry(registry, requestConfig);
                var requestKey = getRequestKey(requestConfig);

                if (!localRegistry.has(requestKey)) {
                    return null;
                }

                return localRegistry.get(requestKey);
            },
            remove: function remove(requestConfig) {
                var localRegistry = getNamespacedRegistry(registry, requestConfig);
                var requestKey = getRequestKey(requestConfig);

                if (localRegistry.has(requestKey)) {
                    localRegistry.delete(requestKey);
                }
            }
        };
    }
});