define('bitbucket/internal/util/scope-type', ['exports', 'bitbucket/internal/enums'], function (exports, _enums) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.scopeNavAndStateMethod = exports.resolveForScopeType = undefined;


    /**
     * Provide resolved map with booleans that indicate which of the scope types is the passed scope.
     * @param {string} scopeType
     * @example
     *     const resolvedScopeType = resolveForScopeType('REPOSITORY');
     *     console.log(resolvedScopeType.REPOSITORY); // true
     *     console.log(resolvedScopeType.PROJECT); // false
     * @returns {Object<string, boolean>}
     */
    function resolveForScopeType(scopeType) {
        return Object.keys(_enums.ScopeType).reduce(function (obj, key) {
            obj[key] = key === scopeType;

            return obj;
        }, {});
    }

    /**
     * Given a scope type will return the appropriate nav builder and current state param methods to use.
     * @param {string} scopeType
     * @returns {string}
     */
    function scopeNavAndStateMethod(scopeType) {
        return scopeType === _enums.ScopeType.REPOSITORY ? {
            nav: 'repository',
            state: 'getRepository'
        } : {
            nav: 'project',
            state: 'getProject'
        };
    }

    exports.resolveForScopeType = resolveForScopeType;
    exports.scopeNavAndStateMethod = scopeNavAndStateMethod;
});