define('bitbucket/internal/util/shortcuts/create-keyboard-shortcuts-handler', ['module', 'exports', 'bitbucket/internal/util/user-keyboard-shortcuts-enabled'], function (module, exports, _userKeyboardShortcutsEnabled) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });


    var inputElements = ['input', 'select', 'textarea'];
    var isInputElement = function isInputElement(element) {
        return inputElements.includes(element.tagName && element.tagName.toLowerCase());
    };

    //Ignore modifier keyboard shortcuts except for shift for now.
    //Shift is easily handled for letter characters by mapping to the capital letter version
    var isAnyModifierPressed = function isAnyModifierPressed(e) {
        return e.altKey || e.ctrlKey || e.metaKey;
    };

    /**
     * Execute handler for first matching key in the keyMap
     *
     * @param {Object.<string, function>} keysMap
     */
    var createKeyboardShortcutsHandler = function createKeyboardShortcutsHandler(keysMap) {
        return function (event) {
            var currentTarget = event.currentTarget,
                target = event.target,
                key = event.key;

            var isEditableElement = isInputElement(target) || target.isContentEditable;

            if (currentTarget !== target && isEditableElement || isAnyModifierPressed(event) || !(0, _userKeyboardShortcutsEnabled.isUserKeyboardShortcutsEnabled)()) {
                //Ignore events raised from text-receiving elements when using delegated event handling.
                return;
            }

            var handler = keysMap[key];

            if (typeof handler === 'function') {
                event.preventDefault();
                event.stopPropagation();

                handler();
            }
        };
    };

    exports.default = createKeyboardShortcutsHandler;
    module.exports = exports['default'];
});