define('bitbucket/internal/util/store/application-properties', ['exports', 'icepick', 'lodash', 'redux', 'reselect', 'bitbucket/internal/util/store/reducers', 'bitbucket/internal/util/store/store'], function (exports, _icepick, _lodash, _redux, _reselect, _reducers, _store) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.selectors = exports.actionCreators = undefined;

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var store = (0, _store2.default)();

    var APP_NAME = 'APPLICATION_PROPERTIES';

    /* ACTIONS */
    var SET_PROPERTIES = 'SET_PROPERTIES';

    /* REDUCER */
    var reducer = (0, _redux.combineReducers)({
        properties: (0, _reducers.reduceByType)({}, _defineProperty({}, SET_PROPERTIES, function () {
            var state = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
            var action = arguments[1];
            return (0, _icepick.merge)(state, action.payload);
        }))
    });

    store.addReducers(_defineProperty({}, APP_NAME, reducer));

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        setProperties: function setProperties(properties) {
            return {
                type: SET_PROPERTIES,
                payload: properties
            };
        },
        setProperty: function setProperty(property, value) {
            return {
                type: SET_PROPERTIES,
                payload: _defineProperty({}, property, value)
            };
        }
    };

    /* SELECTORS */
    var getAppState = function getAppState(state) {
        return (0, _lodash.get)(state, [APP_NAME]);
    };

    var getProperties = (0, _reselect.createSelector)([getAppState], function (state) {
        return (0, _lodash.get)(state, 'properties');
    });

    var getProperty = function getProperty(option) {
        return (0, _reselect.createSelector)([getProperties], function (options) {
            return options.hasOwnProperty(option) ? options[option] : undefined;
        });
    };

    var selectors = exports.selectors = {
        getProperties: getProperties,
        getProperty: getProperty
    };
});