define('bitbucket/internal/util/store/repository', ['exports', 'lodash', 'redux', 'reselect', 'bitbucket/internal/enums', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/rest-actor/rest-actor', 'bitbucket/util/navbuilder', 'bitbucket/util/server', './reducers', './selectors', './store'], function (exports, _lodash, _redux, _reselect, _enums, _entity, _restActor, _navbuilder, _server, _reducers, _selectors, _store) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._reducer = exports._actors = exports.selectors = exports.actionCreators = undefined;

    var nav = _interopRequireWildcard(_navbuilder);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var _restActorsForTypes, _requestTypeKeyProps, _combineReducers;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var store = (0, _store2.default)();
    var APP_NAME = _enums.Entity.REPOSITORY;

    var requestTypes = {
        USER: _enums.Entity.USER,
        PROJECT: _enums.Entity.PROJECT,
        FORKS: 'FORKS',
        RELATED: 'RELATED',
        RECENT: 'RECENT',
        ALL: 'ALL'
    };

    /* ACTIONS */
    var LOAD = 'LOAD_REPOSITORY';
    var LOAD_SUCCESS = 'LOAD_REPOSITORY_SUCCESS';
    var LOAD_FAILURE = 'LOAD_REPOSITORY_FAILURE';
    var LOAD_PAGE = 'LOAD_REPOSITORIES';
    var LOAD_PAGE_SUCCESS = 'LOAD_REPOSITORIES_SUCCESS';
    var LOAD_PAGE_FAILURE = 'LOAD_REPOSITORIES_FAILURE';
    var SAVE = 'SAVE_REPOSITORY';
    var SAVE_SUCCESS = 'SAVE_REPOSITORY_SUCCESS';
    var SAVE_FAILURE = 'SAVE_REPOSITORY_FAILURE';
    var SET_ENTITY = 'SET_REPOSITORY';

    var actors = (0, _restActor.restActorsForTypes)((_restActorsForTypes = {}, _defineProperty(_restActorsForTypes, LOAD, function (_ref) {
        var minimalRepository = _ref.payload;
        return {
            url: nav.rest().repository(minimalRepository).build()
        };
    }), _defineProperty(_restActorsForTypes, SAVE, function (_ref2) {
        var repository = _ref2.payload;
        return {
            url: nav.rest().repository(repository).build(),
            type: _server.method.PUT,
            data: repository
        };
    }), _defineProperty(_restActorsForTypes, LOAD_PAGE, function (action, state) {
        var requestInfo = getRequestInfo(action)(state);

        if ((0, _lodash.get)(requestInfo, 'loading')) {
            return null;
        }

        if ((0, _lodash.get)(requestInfo, 'pagingMeta.isLastPage')) {
            throw new Error('Cannot request beyond the last page');
        }

        var start = (0, _lodash.get)(requestInfo, 'pagingMeta.nextPageStart', 0);

        var _action$payload = action.payload,
            filter = _action$payload.filter,
            _action$payload$limit = _action$payload.limit,
            limit = _action$payload$limit === undefined ? (0, _lodash.get)(requestInfo, 'pagingMeta.limit', _restActor.DEFAULT_PAGE_SIZE) : _action$payload$limit,
            permission = _action$payload.permission,
            project = _action$payload.project,
            requestType = _action$payload.requestType,
            repository = _action$payload.repository,
            user = _action$payload.user,
            visibility = _action$payload.visibility;


        var urlBuilder = void 0;

        switch (requestType) {
            case requestTypes.ALL:
                urlBuilder = nav.rest().allRepos().withDefinedParams({ filter: filter, permission: permission, visibility: visibility });
                break;
            case requestTypes.PROJECT:
                urlBuilder = nav.rest().project(project).allRepos().withDefinedParams({ name: filter });
                break;
            case requestTypes.USER:
                urlBuilder = nav.rest().users(user.slug).repos().withDefinedParams({ name: filter });
                break;
            case requestTypes.FORKS:
                urlBuilder = nav.rest().repository(repository).forks().withDefinedParams({ name: filter });
                break;
            case requestTypes.RELATED:
                urlBuilder = nav.rest().repository(repository).related().withDefinedParams({ name: filter });
                break;
            case requestTypes.RECENT:
                urlBuilder = nav.rest().profile().recent().repos().withDefinedParams({ permission: permission });
                break;
            default:
                throw new Error('Invalid request type');
        }

        return {
            url: urlBuilder.withParams({ avatarSize: _enums.AvatarSize.DEFAULT, limit: limit, start: start }).build()
        };
    }), _restActorsForTypes));

    store.addActors(actors);

    var requestTypeKeyProps = (_requestTypeKeyProps = {}, _defineProperty(_requestTypeKeyProps, requestTypes.ALL, ['visibility', 'permission', 'filter']), _defineProperty(_requestTypeKeyProps, requestTypes.PROJECT, [['project', _entity.getProjectId], 'filter']), _defineProperty(_requestTypeKeyProps, requestTypes.FORKS, [['repository', _entity.getRepositoryId], 'filter']), _defineProperty(_requestTypeKeyProps, requestTypes.RELATED, [['repository', _entity.getRepositoryId], 'filter']), _defineProperty(_requestTypeKeyProps, requestTypes.RECENT, ['permission']), _defineProperty(_requestTypeKeyProps, requestTypes.USER, [['repository', _entity.getUserId], 'filter']), _requestTypeKeyProps);

    var reducer = (0, _redux.combineReducers)({
        entities: (0, _reducers.entitiesReducer)({
            loadPageSuccess: [LOAD_PAGE_SUCCESS],
            loadSingleSuccess: [LOAD_SUCCESS, SAVE_SUCCESS, SET_ENTITY]
        }, _entity.getRepositoryId),
        requests: (0, _redux.combineReducers)((_combineReducers = {}, _defineProperty(_combineReducers, LOAD, (0, _reducers.singleEntityRequestReducer)({
            LOAD: LOAD,
            LOAD_SUCCESS: LOAD_SUCCESS,
            LOAD_FAILURE: LOAD_FAILURE,
            getId: _entity.getRepositoryId
        })), _defineProperty(_combineReducers, SAVE, (0, _reducers.singleEntityRequestReducer)({
            LOAD: SAVE,
            LOAD_SUCCESS: SAVE_SUCCESS,
            LOAD_FAILURE: SAVE_FAILURE,
            getId: _entity.getRepositoryId
        })), _defineProperty(_combineReducers, LOAD_PAGE, (0, _reducers.getRequestPageReducersByType)({
            requestTypeKeyProps: requestTypeKeyProps,
            getId: _entity.getRepositoryId,
            LOAD_PAGE: LOAD_PAGE,
            LOAD_PAGE_FAILURE: LOAD_PAGE_FAILURE,
            LOAD_PAGE_SUCCESS: LOAD_PAGE_SUCCESS
        })), _combineReducers))
    });

    store.addReducers(_defineProperty({}, _enums.Entity.REPOSITORY, reducer));

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        loadRepository: function loadRepository(minimalRepository) {
            return {
                type: LOAD,
                payload: minimalRepository,
                meta: {
                    successType: LOAD_SUCCESS,
                    failureType: LOAD_FAILURE
                }
            };
        },
        saveRepository: function saveRepository(repository) {
            return {
                type: SAVE,
                payload: repository,
                meta: {
                    successType: SAVE_SUCCESS,
                    failureType: SAVE_FAILURE
                }
            };
        },
        setRepository: function setRepository(repository) {
            return {
                type: SET_ENTITY,
                payload: repository
            };
        },
        loadAllRepositories: function loadAllRepositories() {
            var _ref3 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
                filter = _ref3.filter,
                limit = _ref3.limit,
                visibility = _ref3.visibility,
                permission = _ref3.permission;

            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.ALL,
                    filter: filter,
                    limit: limit,
                    permission: permission,
                    visibility: visibility
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        },
        loadProjectRepositories: function loadProjectRepositories(_ref4) {
            var project = _ref4.project,
                filter = _ref4.filter,
                limit = _ref4.limit;
            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.PROJECT,
                    project: project,
                    filter: filter,
                    limit: limit
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        },
        loadUserRepositories: function loadUserRepositories(_ref5) {
            var user = _ref5.user,
                filter = _ref5.filter,
                limit = _ref5.limit;
            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.USER,
                    user: user,
                    filter: filter,
                    limit: limit
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        },
        loadRelatedRepositories: function loadRelatedRepositories(_ref6) {
            var repository = _ref6.repository,
                filter = _ref6.filter,
                limit = _ref6.limit;
            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.RELATED,
                    repository: repository,
                    filter: filter,
                    limit: limit
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        },
        loadRepositoryForks: function loadRepositoryForks(_ref7) {
            var repository = _ref7.repository,
                filter = _ref7.filter,
                limit = _ref7.limit;
            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.FORKS,
                    repository: repository,
                    filter: filter,
                    limit: limit
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        },
        loadRecentRepositories: function loadRecentRepositories() {
            var _ref8 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
                permission = _ref8.permission,
                limit = _ref8.limit;

            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.RECENT,
                    permission: permission,
                    limit: limit
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        }
    };

    /* SELECTORS */

    var _getSelectorsForApp = (0, _selectors.getSelectorsForApp)({
        appName: APP_NAME,
        getId: _entity.getRepositoryId,
        requestTypeKeyProps: requestTypeKeyProps
    }),
        getEntity = _getSelectorsForApp.getEntity,
        getRequestInfo = _getSelectorsForApp.getRequestInfo,
        getEntitiesForRequest = _getSelectorsForApp.getEntitiesForRequest,
        getLoadingForRequest = _getSelectorsForApp.getLoadingForRequest,
        getErrorsForRequest = _getSelectorsForApp.getErrorsForRequest,
        getAllFetchedForRequest = _getSelectorsForApp.getAllFetchedForRequest;

    var selectors = exports.selectors = {
        getRepository: getEntity,
        getRepositoryLoading: function getRepositoryLoading(minimalRepositorySelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([minimalRepositorySelector], actionCreators.loadRepository));
        },
        getRepositoryErrors: function getRepositoryErrors(minimalRepositorySelector) {
            return getErrorsForRequest((0, _reselect.createSelector)([minimalRepositorySelector], actionCreators.loadRepository));
        },
        getRepositorySaving: function getRepositorySaving(repositorySelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([repositorySelector], actionCreators.saveRepository));
        },

        getAllRepositories: function getAllRepositories(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadAllRepositories));
        },
        getAllRepositoriesLoading: function getAllRepositoriesLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadAllRepositories));
        },
        getAllRepositoriesAllFetched: function getAllRepositoriesAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadAllRepositories));
        },

        getProjectRepositories: function getProjectRepositories(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadProjectRepositories));
        },
        getProjectRepositoriesLoading: function getProjectRepositoriesLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadProjectRepositories));
        },
        getProjectRepositoriesAllFetched: function getProjectRepositoriesAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadProjectRepositories));
        },

        getUserRepositories: function getUserRepositories(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadUserRepositories));
        },
        getUserRepositoriesLoading: function getUserRepositoriesLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadUserRepositories));
        },
        getUserRepositoriesAllFetched: function getUserRepositoriesAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadUserRepositories));
        },

        getRelatedRepositories: function getRelatedRepositories(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRelatedRepositories));
        },
        getRelatedRepositoriesLoading: function getRelatedRepositoriesLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRelatedRepositories));
        },
        getRelatedRepositoriesAllFetched: function getRelatedRepositoriesAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRelatedRepositories));
        },

        getRepositoryForks: function getRepositoryForks(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRepositoryForks));
        },
        getRepositoryForksLoading: function getRepositoryForksLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRepositoryForks));
        },
        getRepositoryForksAllFetched: function getRepositoryForksAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRepositoryForks));
        },

        getRecentRepositories: function getRecentRepositories(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRecentRepositories));
        },
        getRecentRepositoriesLoading: function getRecentRepositoriesLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRecentRepositories));
        },
        getRecentRepositoriesAllFetched: function getRecentRepositoriesAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRecentRepositories));
        }
    };

    //Exported for testing only
    exports._actors = actors;
    exports._reducer = reducer;
});