define('bitbucket/internal/util/store/use-application-property', ['module', 'exports', 'react-redux', './application-properties'], function (module, exports, _reactRedux, _applicationProperties) {
  'use strict';

  Object.defineProperty(exports, "__esModule", {
    value: true
  });


  /**
   * Hook that returns an specific application property.
   *
   * @param {String} [property] - Property name
   * @returns {any} - The application property from store
   */
  var useApplicationProperty = function useApplicationProperty(property) {
    return (0, _reactRedux.useSelector)(_applicationProperties.selectors.getProperty(property));
  };

  exports.default = useApplicationProperty;
  module.exports = exports['default'];
});