define('bitbucket/internal/util/store/user', ['exports', 'lodash', 'redux', 'reselect', 'bitbucket/internal/enums', 'bitbucket/internal/util/entity', 'bitbucket/internal/util/rest-actor/rest-actor', 'bitbucket/util/navbuilder', './reducers', './selectors', './store'], function (exports, _lodash, _redux, _reselect, _enums, _entity, _restActor, _navbuilder, _reducers, _selectors, _store) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports._reducer = exports._actors = exports.waitForCurrentUser = exports.selectors = exports.actionCreators = undefined;

    var nav = _interopRequireWildcard(_navbuilder);

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var _restActorsForTypes, _requestTypeKeyProps, _reduceByType, _combineReducers;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    var store = (0, _store2.default)();
    var APP_NAME = _enums.Entity.USER;

    var requestTypes = {
        PR_PARTICIPANTS: 'PR_PARTICIPANTS',
        ALL: 'ALL'
    };

    /* ACTIONS */
    var LOAD = 'LOAD_USER';
    var LOAD_SUCCESS = 'LOAD_USER_SUCCESS';
    var LOAD_FAILURE = 'LOAD_USER_FAILURE';
    var LOAD_PAGE = 'LOAD_USERS';
    var LOAD_PAGE_SUCCESS = 'LOAD_USERS_SUCCESS';
    var LOAD_PAGE_FAILURE = 'LOAD_USERS_FAILURE';
    var SET_ENTITY = 'SET_USER';
    var SET_CURRENT = 'SET_CURRENT_USER';
    var CLEAR_CURRENT = 'CLEAR_CURRENT_USER';

    var actors = (0, _restActor.restActorsForTypes)((_restActorsForTypes = {}, _defineProperty(_restActorsForTypes, LOAD, function (_ref) {
        var user = _ref.payload;
        return {
            url: nav.rest().users(user.slug).build()
        };
    }), _defineProperty(_restActorsForTypes, LOAD_PAGE, function (action, state) {
        var requestInfo = getRequestInfo(function () {
            return action;
        })(state);

        if ((0, _lodash.get)(requestInfo, 'loading')) {
            return null;
        }

        if ((0, _lodash.get)(requestInfo, 'pagingMeta.isLastPage')) {
            throw new Error('Cannot request beyond the last page');
        }

        var start = (0, _lodash.get)(requestInfo, 'pagingMeta.nextPageStart', 0);

        var _action$payload = action.payload,
            direction = _action$payload.direction,
            _action$payload$limit = _action$payload.limit,
            limit = _action$payload$limit === undefined ? (0, _lodash.get)(requestInfo, 'pagingMeta.limit', _restActor.DEFAULT_PAGE_SIZE) : _action$payload$limit,
            filter = _action$payload.filter,
            permission = _action$payload.permission,
            group = _action$payload.group,
            permissions = _action$payload.permissions,
            repository = _action$payload.repository,
            requestType = _action$payload.requestType,
            role = _action$payload.role;


        var urlBuilder = void 0;

        switch (requestType) {
            case requestTypes.PR_PARTICIPANTS:
                urlBuilder = nav.rest().repository(repository).participants().withDefinedParams({
                    direction: direction,
                    filter: filter,
                    role: role
                });
                break;
            case requestTypes.ALL:
                urlBuilder = nav.rest().users().withDefinedParams({ filter: filter, permission: permission, group: group });

                if (permissions && permissions.length) {
                    urlBuilder = permissions.reduce(function (builder, _ref2, i) {
                        var permission = _ref2.permission,
                            repository = _ref2.repository,
                            project = _ref2.project;

                        if (repository) {
                            var _builder$withParams;

                            return builder.withParams((_builder$withParams = {}, _defineProperty(_builder$withParams, 'permission.' + (i + 1), permission), _defineProperty(_builder$withParams, 'repositoryId.' + (i + 1), repository.id), _builder$withParams));
                        } else if (project) {
                            var _builder$withParams2;

                            return builder.withParams((_builder$withParams2 = {}, _defineProperty(_builder$withParams2, 'permission.' + (i + 1), permission), _defineProperty(_builder$withParams2, 'projectId.' + (i + 1), project.id), _builder$withParams2));
                        }

                        return builder;
                    }, urlBuilder);
                }
                break;
            default:
                throw new Error('Invalid request type');
        }

        return {
            url: urlBuilder.withParams({ avatarSize: _enums.AvatarSize.DEFAULT, limit: limit, start: start }).build()
        };
    }), _restActorsForTypes));

    store.addActors(actors);

    /* REDUCERS */
    var requestTypeKeyProps = (_requestTypeKeyProps = {}, _defineProperty(_requestTypeKeyProps, requestTypes.PR_PARTICIPANTS, [['repository', _entity.getRepositoryId], 'direction', 'role', 'filter']), _defineProperty(_requestTypeKeyProps, requestTypes.ALL, ['permission', 'permissions', 'group', 'filter']), _requestTypeKeyProps);

    var reducer = (0, _redux.combineReducers)({
        entities: (0, _reducers.entitiesReducer)({
            loadPageSuccess: [LOAD_PAGE_SUCCESS],
            loadSingleSuccess: [LOAD_SUCCESS, SET_ENTITY, SET_CURRENT]
        }, _entity.getUserId),
        current: (0, _reducers.reduceByType)(null, (_reduceByType = {}, _defineProperty(_reduceByType, SET_CURRENT, function (state, _ref3) {
            var payload = _ref3.payload;

            return (0, _entity.getUserId)(payload);
        }), _defineProperty(_reduceByType, CLEAR_CURRENT, function () {
            return null;
        }), _reduceByType)),
        requests: (0, _redux.combineReducers)((_combineReducers = {}, _defineProperty(_combineReducers, LOAD, (0, _reducers.singleEntityRequestReducer)({
            LOAD: LOAD,
            LOAD_SUCCESS: LOAD_SUCCESS,
            LOAD_FAILURE: LOAD_FAILURE,
            getId: _entity.getUserId
        })), _defineProperty(_combineReducers, LOAD_PAGE, (0, _reducers.getRequestPageReducersByType)({
            requestTypeKeyProps: requestTypeKeyProps,
            getId: _entity.getUserId,
            LOAD_PAGE: LOAD_PAGE,
            LOAD_PAGE_FAILURE: LOAD_PAGE_FAILURE,
            LOAD_PAGE_SUCCESS: LOAD_PAGE_SUCCESS
        })), _combineReducers))
    });

    store.addReducers(_defineProperty({}, APP_NAME, reducer));

    /* ACTION CREATORS */
    var actionCreators = exports.actionCreators = {
        loadUser: function loadUser(_ref4) {
            var slug = _ref4.slug;
            return {
                type: LOAD,
                payload: { slug: slug },
                meta: {
                    successType: LOAD_SUCCESS,
                    failureType: LOAD_FAILURE
                }
            };
        },
        setUser: function setUser(user) {
            return {
                type: SET_ENTITY,
                payload: user
            };
        },
        setCurrentUser: function setCurrentUser(user) {
            return {
                type: SET_CURRENT,
                payload: user
            };
        },
        loadUsers: function loadUsers(_ref5) {
            var filter = _ref5.filter,
                group = _ref5.group,
                limit = _ref5.limit,
                permission = _ref5.permission,
                permissions = _ref5.permissions;
            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.ALL,
                    filter: filter,
                    group: group,
                    limit: limit,
                    permission: permission,
                    permissions: permissions
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        },
        loadRepositoryPrParticipants: function loadRepositoryPrParticipants(_ref6) {
            var direction = _ref6.direction,
                filter = _ref6.filter,
                limit = _ref6.limit,
                repository = _ref6.repository,
                role = _ref6.role;
            return {
                type: LOAD_PAGE,
                payload: {
                    requestType: requestTypes.PR_PARTICIPANTS,
                    direction: direction,
                    filter: filter,
                    limit: limit,
                    repository: repository,
                    role: role
                },
                meta: {
                    successType: LOAD_PAGE_SUCCESS,
                    failureType: LOAD_PAGE_FAILURE
                }
            };
        }
    };

    /* SELECTORS */

    var _getSelectorsForApp = (0, _selectors.getSelectorsForApp)({
        appName: APP_NAME,
        getId: _entity.getUserId,
        requestTypeKeyProps: requestTypeKeyProps
    }),
        getAppState = _getSelectorsForApp.getAppState,
        getEntity = _getSelectorsForApp.getEntity,
        getEntities = _getSelectorsForApp.getEntities,
        getRequestInfo = _getSelectorsForApp.getRequestInfo,
        getEntitiesForRequest = _getSelectorsForApp.getEntitiesForRequest,
        getLoadingForRequest = _getSelectorsForApp.getLoadingForRequest,
        getAllFetchedForRequest = _getSelectorsForApp.getAllFetchedForRequest;

    var getCurrentUserId = (0, _reselect.createSelector)([getAppState], function (userState) {
        return (0, _lodash.get)(userState, 'current');
    });

    var getCurrentUser = (0, _reselect.createSelector)([getEntities, getCurrentUserId], function (users, currentUserId) {
        return (0, _lodash.get)(users, currentUserId);
    });

    var selectors = exports.selectors = {
        getUser: getEntity,
        getUserLoading: function getUserLoading(minimalUserSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([minimalUserSelector], actionCreators.loadUser));
        },
        getCurrentUser: getCurrentUser,

        getUsers: function getUsers(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadUsers));
        },
        getUsersLoading: function getUsersLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadUsers));
        },
        getUsersAllFetched: function getUsersAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadUsers));
        },

        getRepositoryPrParticipants: function getRepositoryPrParticipants(requestParamsSelector) {
            return getEntitiesForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRepositoryPrParticipants));
        },
        getRepositoryPrParticipantsLoading: function getRepositoryPrParticipantsLoading(requestParamsSelector) {
            return getLoadingForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRepositoryPrParticipants));
        },
        getRepositoryPrParticipantsAllFetched: function getRepositoryPrParticipantsAllFetched(requestParamsSelector) {
            return getAllFetchedForRequest((0, _reselect.createSelector)([requestParamsSelector], actionCreators.loadRepositoryPrParticipants));
        }
    };

    var waitForCurrentUser = exports.waitForCurrentUser = function waitForCurrentUser() {
        //Wait until there is a current user in the store.
        //Unsubscribe and resolve the promise as soon as we have a current user
        return new Promise(function (resolve) {
            var unsubscribeStore = store.subscribe(function () {
                var currentUser = selectors.getCurrentUser(store.getState());

                if (!currentUser) {
                    return;
                }

                unsubscribeStore();

                resolve(currentUser);
            });
        });
    };

    //Exported for testing only
    exports._actors = actors;
    exports._reducer = reducer;
});