define('bitbucket/internal/util/store/user.test', ['lodash', './store', './user'], function (_lodash, _store, _user) {
    'use strict';

    var _store2 = _interopRequireDefault(_store);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    jest.mock('./store', function () {
        return (0, _lodash.once)(function () {
            return {
                addActors: jest.fn(),
                addReducers: jest.fn(),
                subscribe: jest.fn(),
                getState: jest.fn()
            };
        });
    });

    var store = void 0;

    beforeEach(function () {
        store = (0, _store2.default)();

        store.addActors.mockReset();
        store.addReducers.mockReset();
        store.subscribe.mockReset();
        store.getState.mockReset();
    });

    describe(_user.waitForCurrentUser, function () {
        it('resolves with the current user and unsubscribes', function () {
            var callback = void 0;
            var unsubscribe = jest.fn();
            var admin = {
                name: 'admin',
                emailAddress: 'admin@example.com',
                id: 1,
                displayName: 'Administrator',
                active: true,
                slug: 'admin',
                type: 'NORMAL',
                links: {
                    self: [{
                        href: 'http://localhost:7990/bitbucket/users/admin'
                    }]
                },
                avatarUrl: '/bitbucket/users/admin/avatar.png?s=64&v=1565058480713'
            };

            store.subscribe.mockImplementation(function (fn) {
                callback = fn;

                return unsubscribe;
            });

            store.getState.mockReturnValue({
                USER: {
                    entities: {
                        admin: admin
                    },
                    current: 'admin'
                }
            });

            var userPromise = (0, _user.waitForCurrentUser)();

            callback();

            expect(unsubscribe).toBeCalled();

            return expect(userPromise).resolves.toBe(admin);
        });
    });
});