define('bitbucket/internal/util/syntax-highlight/highlight-codeblock', ['exports', 'codemirror', 'bitbucket/internal/util/determine-language'], function (exports, _codemirror, _determineLanguage) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.highlightCodeblock = highlightCodeblock;

    var _codemirror2 = _interopRequireDefault(_codemirror);

    var _determineLanguage2 = _interopRequireDefault(_determineLanguage);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /**
     * Highlight a code block element.
     * The code element is expected to have a data-language attribute and be inside of a pre element.
     * i.e. pre > code[data-language]
     *
     * @param {Object} Options
     * @property {HTMLElement} codeBlock - A code element.
     * @property {String} mode - CodeMirror mode
     * @property {String} text - Text to highlight
     * @property {Function} [callback] - An additional callback function for CodeMirror runMode
     * @return {Promise}
     */
    function highlightCodeblock(_ref) {
        var codeblock = _ref.codeblock,
            mode = _ref.mode,
            text = _ref.text,
            callback = _ref.callback;

        return new Promise(function (resolve, reject) {
            _determineLanguage2.default.getCodeMirrorModeForName(mode).then(function (codeMirrorMode) {
                _codemirror2.default.runMode(text, codeMirrorMode.mime || { name: mode }, callback || codeblock);

                resolve();
            }).fail(function (reason) {
                console.warn(reason || mode + ' could not be loaded for syntax highlighting.');

                reject();
            });
        });
    }
});