define('bitbucket/internal/util/syntax-highlight/whitespace-overlay-mode', ['exports', 'codemirror'], function (exports, _codemirror) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.WHITESPACE_OVERLAY = undefined;

    var _codemirror2 = _interopRequireDefault(_codemirror);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var WHITESPACE_OVERLAY = exports.WHITESPACE_OVERLAY = 'whitespace-characters';
    var space = ' ';
    var whitespaceClass = 'whitespace';
    var tab = '\t';
    var tabClass = 'tab';

    _codemirror2.default.defineMode(WHITESPACE_OVERLAY, function (config) {
        var _ref = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
            _ref$baseMode = _ref.baseMode,
            baseMode = _ref$baseMode === undefined ? 'text/plain' : _ref$baseMode;

        var whitespaceOverlay = {
            name: WHITESPACE_OVERLAY,
            flattenSpans: false, //required to prevent adjacent whitespace spans from being merged
            token: function token(stream) {
                if (stream.match(space, false)) {
                    stream.eatWhile(function (char) {
                        return char === space;
                    });

                    return whitespaceClass;
                }

                if (stream.match(tab, false)) {
                    //Just eat one tab at a time
                    stream.eat(tab);

                    return tabClass;
                }
                stream.eatWhile(/[^ \t]/);

                return null;
            }
        };

        return _codemirror2.default.overlayMode(_codemirror2.default.getMode(config, baseMode), whitespaceOverlay);
    });
});