define('bitbucket/internal/util/time-i18n-mappings', ['exports', '@atlassian/aui'], function (exports, _aui) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.commentEditedAgeMapping = undefined;
    var commentEditedAgeMapping = exports.commentEditedAgeMapping = {
        aMomentAgo: function aMomentAgo() {
            return _aui.I18n.getText('bitbucket.date.format.edited.a.moment.ago');
        },
        oneMinuteAgo: function oneMinuteAgo() {
            return _aui.I18n.getText('bitbucket.date.format.edited.one.minute.ago');
        },
        xMinutesAgo: function xMinutesAgo(param) {
            return _aui.I18n.getText('bitbucket.date.format.edited.x.minutes.ago', param);
        },
        oneHourAgo: function oneHourAgo() {
            return _aui.I18n.getText('bitbucket.date.format.edited.one.hour.ago');
        },
        xHoursAgo: function xHoursAgo(param) {
            return _aui.I18n.getText('bitbucket.date.format.edited.x.hours.ago', param);
        },
        oneDayAgo: function oneDayAgo() {
            return _aui.I18n.getText('bitbucket.date.format.edited.one.day.ago');
        },
        xDaysAgo: function xDaysAgo(param) {
            return _aui.I18n.getText('bitbucket.date.format.edited.x.days.ago', param);
        },
        oneWeekAgo: function oneWeekAgo() {
            return _aui.I18n.getText('bitbucket.date.format.edited.one.week.ago');
        },
        absolute: function absolute(param) {
            return _aui.I18n.getText('bitbucket.date.format.edited.absolute', param);
        }
    };

    exports.default = {
        commentEditedAge: commentEditedAgeMapping
    };
});