define('bitbucket/internal/util/version-upgraded', ['exports', 'bitbucket/internal/util/user-created-version'], function (exports, _userCreatedVersion) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.onlyPatchVersionUpgraded = exports.majorOrMinorVersionUpgraded = undefined;


    /**
     * Check if user has upgraded to a new version. Only check major version and minor version. Ignore patch version
     *
     * @param {string} previousVersion - a version string in the format "1.2.3", i.e. "Major.Minor.Patch"
     * @param {string} currentVersion - a version string in the format "1.2.3", i.e. "Major.Minor.Patch"
     * @param {boolean} isMinorVersionEqual - a boolean indicates whether the minor version can be equal
     * @returns {boolean}
     */
    var majorOrMinorVersionUpgraded = exports.majorOrMinorVersionUpgraded = function majorOrMinorVersionUpgraded(previousVersion, currentVersion) {
        var isMinorVersionEqual = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

        var mappedPreviousVersion = (0, _userCreatedVersion.mapVersion)(previousVersion);
        var mappedCurrentVersion = (0, _userCreatedVersion.mapVersion)(currentVersion);

        // if major is less
        if (mappedPreviousVersion.major < mappedCurrentVersion.major) {
            return true;
        }
        // if majors are the same but minor is less (or isMinorVersionEqual)
        if (mappedPreviousVersion.major === mappedCurrentVersion.major && (isMinorVersionEqual && mappedPreviousVersion.minor <= mappedCurrentVersion.minor || !isMinorVersionEqual && mappedPreviousVersion.minor < mappedCurrentVersion.minor)) {
            return true;
        }

        return false;
    };

    var onlyPatchVersionUpgraded = exports.onlyPatchVersionUpgraded = function onlyPatchVersionUpgraded() {
        var previousVersion = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
        var currentVersion = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
        var isPatchVersionEqual = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

        var mappedPreviousVersion = (0, _userCreatedVersion.mapVersion)(previousVersion);
        var mappedCurrentVersion = (0, _userCreatedVersion.mapVersion)(currentVersion);

        // if majors and minors are the same but patch is less (or isMinorVersionEqual)
        if (mappedPreviousVersion && mappedCurrentVersion && mappedPreviousVersion.major === mappedCurrentVersion.major && mappedPreviousVersion.minor === mappedCurrentVersion.minor && (isPatchVersionEqual && mappedPreviousVersion.patch <= mappedCurrentVersion.patch || !isPatchVersionEqual && mappedPreviousVersion.patch < mappedCurrentVersion.patch)) {
            return true;
        }

        return false;
    };
});