define('bitbucket/internal/widget/breadcrumbs/breadcrumbs', ['module', 'exports', 'jquery', 'lodash', 'bitbucket/internal/model/page-state', 'bitbucket/internal/util/dom-event', 'bitbucket/internal/util/events', 'bitbucket/util/navbuilder', 'bitbucket/util/state'], function (module, exports, _jquery, _lodash, _pageState, _domEvent, _events, _navbuilder, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var _pageState2 = _interopRequireDefault(_pageState);

    var _domEvent2 = _interopRequireDefault(_domEvent);

    var _events2 = _interopRequireDefault(_events);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function Breadcrumbs(containerSelector) {
        this.$container = (0, _jquery2.default)(containerSelector);
        var self = this;
        this.$container.on('click', 'a', function (e) {
            if (_domEvent2.default.openInSameTab(e)) {
                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.widget.breadcrumbs.urlChanged', self, (0, _jquery2.default)(this).attr('href'));
                e.preventDefault();
            }
        });
    }

    var browseNavBuilder = nav.repository(_state2.default.getRepository()).browse();

    var browsePath = function browsePath(pathComponents, revisionReference) {
        if (!revisionReference.isDefault()) {
            return browseNavBuilder.path(pathComponents).at(revisionReference.getId()).build();
        }

        return browseNavBuilder.path(pathComponents).build();
    };

    function createBreadcrumbData(revisionReference, pathComponents) {
        var pathSeed = [];
        var breadcrumbParts = _lodash2.default.map(pathComponents, function (part) {
            pathSeed = pathSeed.slice(0); //shallow copy
            pathSeed.push(part);

            return {
                text: part,
                url: browsePath(pathSeed, revisionReference)
            };
        });

        //prepend repository link
        breadcrumbParts.unshift({
            text: _pageState2.default.getRepository().getName(),
            url: browsePath([], revisionReference)
        });

        return breadcrumbParts;
    }

    Breadcrumbs.prototype.update = function (revisionReference, path, isDirectory, lockedFile) {
        this.$container.empty().append(bitbucket.internal.widget.breadcrumbs.breadcrumbs.crumbs({
            pathComponents: createBreadcrumbData(revisionReference, path.getComponents()),
            trailingSlash: isDirectory,
            isLockedFile: lockedFile
        }));

        if (lockedFile) {
            this.$container.find('.aui-iconfont-lock-filled').tooltip();
        }
    };

    exports.default = Breadcrumbs;
    module.exports = exports['default'];
});