define('bitbucket/internal/widget/dropdown-menu/dropdown-menu', ['exports', '@atlassian/aui', 'classnames', 'prop-types', 'react'], function (exports, _aui, _classnames, _propTypes, _react) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.DropdownMenu = exports.DropdownMenuTrigger = exports.DropdownMenuItem = exports.DropdownMenuSection = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    // used to create separate groups of related items and may include heading
    var DropdownMenuSection = exports.DropdownMenuSection = function DropdownMenuSection(_ref) {
        var id = _ref.id,
            label = _ref.label,
            children = _ref.children,
            className = _ref.className,
            testId = _ref.testId;

        return _react2.default.createElement(
            'div',
            {
                className: (0, _classnames2.default)(className, 'aui-dropdown2-section'),
                label: label,
                'data-testid': testId
            },
            label && _react2.default.createElement(
                'span',
                { 'aria-hidden': 'true', className: 'aui-dropdown2-heading', id: id },
                label
            ),
            _react2.default.createElement(
                'div',
                { className: 'aui-dropdown2-item-group', role: 'group', 'aria-labelledby': id },
                children
            )
        );
    };

    DropdownMenuSection.propTypes = {
        children: _propTypes2.default.node.isRequired,
        id: _propTypes2.default.string.isRequired,
        label: _propTypes2.default.string,
        className: _propTypes2.default.string,
        testId: _propTypes2.default.string
    };

    var DropdownMenuItem = exports.DropdownMenuItem = function DropdownMenuItem(_ref2) {
        var onSelect = _ref2.onSelect,
            className = _ref2.className,
            children = _ref2.children,
            isDisabled = _ref2.isDisabled,
            testId = _ref2.testId;

        if (!onSelect) {
            return null;
        }
        var clickHandler = function clickHandler(e) {
            e.preventDefault();
            if (isDisabled) {
                return;
            }
            onSelect(e);
        };

        return _react2.default.createElement(
            'li',
            null,
            _react2.default.createElement(
                'a',
                {
                    onClick: clickHandler,
                    href: '#',
                    role: 'menuitem',
                    className: (0, _classnames2.default)(className, { 'aui-dropdown2-disabled': isDisabled }),
                    'aria-disabled': isDisabled,
                    'data-testid': testId
                },
                children
            )
        );
    };

    DropdownMenuItem.propTypes = {
        children: _propTypes2.default.node.isRequired,
        className: _propTypes2.default.string,
        onSelect: _propTypes2.default.func,
        testId: _propTypes2.default.string
    };

    var DropdownMenuTrigger = exports.DropdownMenuTrigger = function DropdownMenuTrigger(_ref3) {
        var text = _ref3.text,
            iconClass = _ref3.iconClass,
            _ref3$subtle = _ref3.subtle,
            subtle = _ref3$subtle === undefined ? true : _ref3$subtle,
            id = _ref3.id,
            onFocus = _ref3.onFocus,
            disabled = _ref3.disabled;

        var subtleClasses = subtle ? 'aui-button-subtle aui-dropdown2-trigger-arrowless' : '';
        var innerContent = text;

        if (iconClass) {
            innerContent = _react2.default.createElement(
                'span',
                { className: 'aui-icon aui-icon-small ' + iconClass },
                text
            );
        }

        return _react2.default.createElement(
            'button',
            {
                type: 'button',
                className: 'aui-button aui-dropdown2-trigger ' + subtleClasses,
                'aria-haspopup': 'true',
                'aria-owns': id,
                onFocus: onFocus,
                'aria-disabled': disabled,
                disabled: disabled
            },
            innerContent
        );
    };

    DropdownMenuTrigger.propTypes = {
        text: _propTypes2.default.string.isRequired,
        iconClass: _propTypes2.default.string,
        subtle: _propTypes2.default.bool,
        id: _propTypes2.default.string.isRequired
    };

    var DropdownMenu = exports.DropdownMenu = function (_PureComponent) {
        _inherits(DropdownMenu, _PureComponent);

        function DropdownMenu() {
            _classCallCheck(this, DropdownMenu);

            return _possibleConstructorReturn(this, (DropdownMenu.__proto__ || Object.getPrototypeOf(DropdownMenu)).apply(this, arguments));
        }

        _createClass(DropdownMenu, [{
            key: 'render',
            value: function render() {
                var _props = this.props,
                    id = _props.id,
                    children = _props.children,
                    Trigger = _props.Trigger,
                    onFocus = _props.onFocus,
                    disabled = _props.disabled;


                return _react2.default.createElement(
                    _react.Fragment,
                    null,
                    Trigger ? _react2.default.createElement(Trigger, { onFocus: onFocus }) : _react2.default.createElement(DropdownMenuTrigger, {
                        id: this.props.id,
                        text: _aui.I18n.getText('bitbucket.web.actions'),
                        iconClass: 'aui-iconfont-more',
                        onFocus: onFocus,
                        disabled: disabled
                    }),
                    _react2.default.createElement(
                        'div',
                        {
                            id: id,
                            className: 'aui-dropdown2 aui-style-default aui-layer',
                            role: 'menu',
                            'aria-hidden': 'true'
                        },
                        _react2.default.createElement(
                            'ul',
                            { className: 'aui-list-truncate' },
                            children
                        )
                    )
                );
            }
        }]);

        return DropdownMenu;
    }(_react.PureComponent);

    DropdownMenu.propTypes = {
        id: _propTypes2.default.string.isRequired,
        children: _propTypes2.default.node.isRequired,
        disabled: _propTypes2.default.bool,
        Trigger: _propTypes2.default.node,
        onFocus: _propTypes2.default.func
    };
});