define('bitbucket/internal/widget/filterable-entity-table/entity-rest-actor', ['exports', 'icepick', 'bitbucket/internal/bbui/paged-table/paged-table', 'bitbucket/internal/util/analytics', 'bitbucket/util/server'], function (exports, _icepick, _pagedTable, _analytics, _server) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.loadEntitiesRestActor = exports.searchResponseTransformer = undefined;

    var analytics = _interopRequireWildcard(_analytics);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    /**
     * Pluck the entity page out of the search response and copy `nextStart` to `nextPageStart`
     * to conform with our standard paging.
     *
     * @param {String} entityName
     *
     * @returns {function(response: Object)}
     *
     */
    var searchResponseTransformer = exports.searchResponseTransformer = function searchResponseTransformer(entityName) {
        return function (response) {
            var searchEntityData = response[entityName];

            return searchEntityData ? (0, _icepick.set)(searchEntityData, 'nextPageStart', searchEntityData.nextPageStart || searchEntityData.nextStart) : response;
        };
    };

    /**
     * Rest actor for loading paged, filtered entities.
     * Supports a search fallback urlBuilder to handle disabled or incorrectly configured search server
     *
     * @param {Object} options
     * @param {String} options.loadAction
     * @param {bitbucket/util/navbuilder.Builder} options.urlBuilder
     * @param {bitbucket/util/navbuilder.Builder} [options.fallbackBuilder]
     * @param {Function} [options.responseTransformer]
     * @param {Object} [options.statusCode]
     *
     * @returns {function({type: String, payload?: Object, meta: Object}, Function)}
     */
    var loadEntitiesRestActor = exports.loadEntitiesRestActor = function loadEntitiesRestActor(_ref) {
        var loadAction = _ref.loadAction,
            urlBuilder = _ref.urlBuilder,
            fallbackBuilder = _ref.fallbackBuilder,
            responseTransformer = _ref.responseTransformer,
            statusCode = _ref.statusCode;

        var useFallback = false;

        return function (_ref2, dispatch) {
            var type = _ref2.type,
                _ref2$payload = _ref2.payload,
                payload = _ref2$payload === undefined ? {} : _ref2$payload,
                meta = _ref2.meta;

            if (type !== loadAction) {
                return;
            }

            var _payload$start = payload.start,
                start = _payload$start === undefined ? 0 : _payload$start,
                _payload$limit = payload.limit,
                limit = _payload$limit === undefined ? _pagedTable.DEFAULT_PAGE_SIZE : _payload$limit,
                filter = payload.filter,
                selectFilter = payload.selectFilter;


            var fallback = function fallback() {
                useFallback = true;

                analytics.add('entity-rest-actor.fallback.used');

                return (0, _server.rest)({
                    url: fallbackBuilder({ filter: filter, selectFilter: selectFilter }).withParams({ start: start, limit: limit }).build()
                });
            };

            (0, _server.rest)({
                url: (useFallback ? fallbackBuilder : urlBuilder)({ filter: filter, selectFilter: selectFilter }).withParams({ start: start, limit: limit }).build(),
                statusCode: _extends({}, statusCode, !useFallback && fallbackBuilder && {
                    // The order of args for a failed request is `jqXhr`, `textStatus`, `errorThrown`,
                    // a successful request will have the `data` as the first arg and the `jqXhr` as the 3rd arg.
                    // (See bitbucket/util/server: ajaxPipe() -> fail() vs ajaxPipe() -> done())
                    // Since this only cares about error cases, it will use the args in that order.
                    // To short-circuit, the first check is for the `textStatus`, since that is
                    // the 2nd arg in both cases.
                    '*': function _(jqXhr, textStatus) {
                        if (textStatus === 'error' && jqXhr && jqXhr.status >= 400) {
                            return true;
                        }

                        return false;
                    },
                    404: fallback,
                    500: fallback,
                    503: fallback
                })
            }).done(function (data) {
                dispatch({
                    type: type + '_SUCCESS',
                    payload: responseTransformer ? responseTransformer(data) : data,
                    meta: _extends({}, meta, { filter: filter, selectFilter: selectFilter })
                });
            }).fail(function (err) {
                dispatch({
                    type: type + '_FAILURE',
                    payload: err,
                    meta: _extends({}, meta, { filter: filter, selectFilter: selectFilter })
                });
            });
        };
    };
});