define('bitbucket/internal/widget/filterable-entity-table/filterable-entity-table', ['exports', '@atlassian/aui', 'classnames', 'jquery', 'lodash', 'prop-types', 'react', 'react-dom', 'react-redux', 'bitbucket/internal/bbui/paged-table/paged-table', 'bitbucket/internal/util/shortcuts', './action-creators', './selectors'], function (exports, _aui, _classnames, _jquery, _lodash, _propTypes, _react, _reactDom, _reactRedux, _pagedTable, _shortcuts, _actionCreators, _selectors) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.connectEntityTable = exports.filterableOverrideMerge = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _reactDom2 = _interopRequireDefault(_reactDom);

    var _pagedTable2 = _interopRequireDefault(_pagedTable);

    var shortcuts = _interopRequireWildcard(_shortcuts);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];
                descriptor.enumerable = descriptor.enumerable || false;
                descriptor.configurable = true;
                if ("value" in descriptor) descriptor.writable = true;
                Object.defineProperty(target, descriptor.key, descriptor);
            }
        }

        return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);
            if (staticProps) defineProperties(Constructor, staticProps);
            return Constructor;
        };
    }();

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var createKeyboardShortcutsHandler = shortcuts.createKeyboardShortcutsHandler;
    // FIXME: Remove me once we fix the babel export/import issue

    var NO_FILTER = '';

    /**
     * Allow the `filterable` prop from state to override ownProps only when it is explicitly set.
     * @param {Object} stateProps
     * @param {Object} dispatchProps
     * @param {Object} ownProps
     */
    var filterableOverrideMerge = exports.filterableOverrideMerge = function filterableOverrideMerge(stateProps, dispatchProps, ownProps) {
        return _extends({}, ownProps, (0, _lodash.omit)(stateProps, 'filterable'), dispatchProps, {
            filterable: (0, _lodash.isBoolean)(stateProps.filterable) ? stateProps.filterable : ownProps.filterable
        });
    };

    /**
     * Connect a given entity table to the store using the entity helpers
     *
     * @param {String} entityName
     * @param {String} loadAction
     * @param {FilterableEntityTable} Table
     */
    var connectEntityTable = exports.connectEntityTable = function connectEntityTable(entityName, loadAction, Table) {
        return (0, _reactRedux.connect)(
        // mapStateToProps - returns state of store
        (0, _selectors.getStateForEntity)(entityName),
        // mapDispatchToProps - dispatch actions of store
        (0, _actionCreators.entityActionCreators)(loadAction), filterableOverrideMerge)(Table);
    };

    var FilterableEntityTable = function (_PureComponent) {
        _inherits(FilterableEntityTable, _PureComponent);

        function FilterableEntityTable() {
            var _ref;

            var _temp, _this, _ret;

            _classCallCheck(this, FilterableEntityTable);

            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
                args[_key] = arguments[_key];
            }

            return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = FilterableEntityTable.__proto__ || Object.getPrototypeOf(FilterableEntityTable)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
                focusedEntity: null,
                filterFocused: false,
                filter: null,
                entities: null
            }, _this.onFilterChange = (0, _lodash.debounce)(function (filter) {
                var _this$props = _this.props,
                    selectFilter = _this$props.selectFilter,
                    _this$props$limit = _this$props.limit,
                    limit = _this$props$limit === undefined ? _this.props.pageSize : _this$props$limit,
                    start = _this$props.nextPageStart,
                    loadEntities = _this$props.loadEntities,
                    setFilter = _this$props.setFilter,
                    refreshOnFilterReset = _this$props.refreshOnFilterReset;

                setFilter(filter);
                // refreshOnFilterReset: flag to fetch latest values when input filter is cleared
                if (refreshOnFilterReset && filter === NO_FILTER) loadEntities({ filter: filter, selectFilter: selectFilter, start: start, limit: limit });
            }, 250), _this.blurFilter = function () {
                return _this.setState({ filterFocused: false });
            }, _this.focusFilter = function () {
                return _this.setState({ filterFocused: true });
            }, _this.focusNext = function () {
                var entities = _this.props.entities;


                _this.setState(function (_ref2) {
                    var focusedEntity = _ref2.focusedEntity;
                    return {
                        focusedEntity: entities[Math.min(entities.indexOf(focusedEntity) + 1, entities.length - 1)]
                    };
                });
            }, _this.focusPrev = function () {
                var entities = _this.props.entities;


                _this.setState(function (_ref3) {
                    var focusedEntity = _ref3.focusedEntity;
                    return {
                        focusedEntity: entities[Math.max(entities.indexOf(focusedEntity) - 1, 0)]
                    };
                });
            }, _this.open = function () {
                _this._openHandler && _this._openHandler();
            }, _this.onKeydown = createKeyboardShortcutsHandler({
                f: _this.focusFilter,
                j: _this.focusNext,
                k: _this.focusPrev,
                o: _this.open
            }), _this.onFocusCallback = function (focusedEntity) {
                _this.setState({ focusedEntity: focusedEntity });
            }, _this.onSelectFilterChange = function (e) {
                var setSelectFilter = _this.props.setSelectFilter;


                // dispatch select filter changed action
                setSelectFilter(e.target.value);
                // update URL if required
                if (!!_this.props.onSelectFilterChange) {
                    _this.props.onSelectFilterChange({
                        selectFilter: e.target.value
                    });
                }
            }, _temp), _possibleConstructorReturn(_this, _ret);
        }

        _createClass(FilterableEntityTable, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                document.addEventListener('keydown', this.onKeydown);
            }
        }, {
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                document.removeEventListener('keydown', this.onKeydown);
            }
        }, {
            key: 'render',
            value: function render() {
                var _this2 = this;

                var _props = this.props,
                    bufferPx = _props.bufferPx,
                    className = _props.className,
                    containerElement = _props.containerElement,
                    emptyState = _props.emptyState,
                    enabled = _props.enabled,
                    entities = _props.entities,
                    filter = _props.filter,
                    filterable = _props.filterable,
                    filterPlaceholder = _props.filterPlaceholder,
                    filterVisible = _props.filterVisible,
                    header = _props.header,
                    isLastPage = _props.isLastPage,
                    lastPageMessage = _props.lastPageMessage,
                    _props$limit = _props.limit,
                    limit = _props$limit === undefined ? this.props.pageSize : _props$limit,
                    loadEntities = _props.loadEntities,
                    loading = _props.loading,
                    loadMoreMessage = _props.loadMoreMessage,
                    start = _props.nextPageStart,
                    noItemsMessage = _props.noItemsMessage,
                    _props$row = _props.row,
                    row = _props$row === undefined ? this.row : _props$row,
                    scrollToLoad = _props.scrollToLoad,
                    shouldScrollOnFocus = _props.shouldScrollOnFocus,
                    scrollElement = _props.scrollElement,
                    showTableIfNoResults = _props.showTableIfNoResults,
                    showSelectFilter = _props.showSelectFilter,
                    selectFilter = _props.selectFilter,
                    selectFilterProps = _props.selectFilterProps,
                    showEmptyStateWithFilter = _props.showEmptyStateWithFilter,
                    emptyStateWithFilterProps = _props.emptyStateWithFilterProps;
                var _state = this.state,
                    filterFocused = _state.filterFocused,
                    focusedEntity = _state.focusedEntity;


                //If the unfiltered list is empty, don't show the filter input
                var listIsFilterable = !(!filter && !entities.length);
                //Disable the filter if the table is not enabled or if there are no items to filter
                var filterDisabled = filterVisible && (!listIsFilterable || !enabled);

                if (!filter && !entities.length && isLastPage && emptyState) {
                    //Only show empty state when there are no unfiltered results
                    return emptyState;
                }

                return _react2.default.createElement(
                    'div',
                    { className: (0, _classnames2.default)(className, 'filterable-entity-table') },
                    (listIsFilterable || filterVisible) && (showSelectFilter || filterable) && _react2.default.createElement(
                        'div',
                        { className: 'paged-table-filter' },
                        showSelectFilter && _react2.default.createElement(FilterSelect, _extends({}, selectFilterProps, {
                            value: selectFilter || selectFilterProps.value,
                            onChange: this.onSelectFilterChange
                        })),
                        filterable && _react2.default.createElement(FilterInput, {
                            onKeyDown: createKeyboardShortcutsHandler({
                                ArrowDown: this.focusNext,
                                ArrowUp: this.focusPrev,
                                Enter: this.open
                            }),
                            onInput: function onInput(e) {
                                return _this2.onFilterChange(e.target.value);
                            },
                            onBlur: this.blurFilter,
                            onFocus: this.focusFilter,
                            focused: filterFocused,
                            placeholder: filterPlaceholder,
                            disabled: filterDisabled
                        })
                    ),
                    _react2.default.createElement(_pagedTable2.default, {
                        allFetched: isLastPage,
                        allFetchedMessage: lastPageMessage,
                        bufferPx: bufferPx,
                        className: 'entity-table',
                        containerElement: containerElement,
                        focusedIndex: entities.indexOf(focusedEntity),
                        header: header,
                        items: entities,
                        loading: loading,
                        loadMoreMessage: loadMoreMessage,
                        noItemsMessage: noItemsMessage,
                        onFocusCallback: this.onFocusCallback,
                        onMoreItemsRequested: function onMoreItemsRequested() {
                            return loadEntities({ filter: filter, selectFilter: selectFilter, start: start, limit: limit });
                        },
                        pageSize: limit,
                        row: row,
                        openCallback: function openCallback(fn) {
                            return _this2._openHandler = fn;
                        },
                        scrollElement: scrollElement,
                        scrollToLoad: scrollToLoad,
                        shouldScrollOnFocus: shouldScrollOnFocus,
                        shouldNativeFocus: !filterFocused,
                        showTableIfNoResults: showTableIfNoResults,
                        showEmptyState: showEmptyStateWithFilter,
                        emptyStateProps: emptyStateWithFilterProps
                    })
                );
            }
        }], [{
            key: 'getDerivedStateFromProps',
            value: function getDerivedStateFromProps(_ref4, prevState) {
                var entities = _ref4.entities,
                    filter = _ref4.filter;

                var changes = {
                    entities: entities,
                    filter: filter
                };

                if (!prevState.focusedEntity || // initializing.
                (0, _lodash.get)(filter, 'length', 0) < prevState.filter.length || //Filter cleared or shortened (i.e. backspaced)
                entities.length && !(0, _lodash.includes)(entities, prevState.focusedEntity) || //Entity is not in new list
                !prevState.filter && filter && prevState.focusedEntity === prevState.entities[0] //Initial auto-focus
                ) {
                        // Always reset the focused entity to the first entity:
                        // when clearing or shortening the filter,
                        // when the focusedEntity doesn't exist in the new list and
                        // don't preserve the initial auto-focus of first item in unfiltered list when transitioning to filtered
                        changes.focusedEntity = entities[0];
                    }

                return changes;
            }
        }]);

        return FilterableEntityTable;
    }(_react.PureComponent);

    FilterableEntityTable.propTypes = {
        bufferPx: _propTypes2.default.number,
        className: _propTypes2.default.string,
        containerElement: _pagedTable2.default.propTypes.containerElement,
        emptyState: _propTypes2.default.element,
        emptyStateWithFilterProps: _propTypes2.default.object,
        enabled: _propTypes2.default.bool,
        entities: _propTypes2.default.array,
        filter: _propTypes2.default.string,
        filterable: _propTypes2.default.bool,
        filterPlaceholder: _propTypes2.default.string,
        filterVisible: _propTypes2.default.bool,
        header: _propTypes2.default.node,
        isLastPage: _propTypes2.default.bool,
        lastPageMessage: _propTypes2.default.string,
        limit: _propTypes2.default.number,
        loadEntities: _propTypes2.default.func,
        loading: _propTypes2.default.bool,
        loadMoreMessage: _propTypes2.default.string,
        nextPageStart: _propTypes2.default.number,
        noItemsMessage: _propTypes2.default.string,
        pageSize: _propTypes2.default.number,
        row: _propTypes2.default.func,
        scrollToLoad: _propTypes2.default.bool,
        scrollElement: _pagedTable2.default.propTypes.scrollElement,

        // Should scroll window to the focused element
        shouldScrollOnFocus: _propTypes2.default.bool,
        showTableIfNoResults: _propTypes2.default.bool,

        //
        showEmptyStateWithFilter: _propTypes2.default.bool,
        showSelectFilter: _propTypes2.default.bool,
        selectFilter: _propTypes2.default.string,
        selectFilterProps: _propTypes2.default.object,
        onSelectFilterChange: _propTypes2.default.func,
        refreshOnFilterReset: _propTypes2.default.bool
    };
    FilterableEntityTable.defaultProps = {
        enabled: true,
        filterable: false,
        header: _react2.default.createElement(
            'tr',
            null,
            _react2.default.createElement(
                'th',
                null,
                _aui.I18n.getText('bitbucket.web.entity.col.name')
            )
        ),
        isLastPage: false, //For tables with no initial page of data, the default should be to request it
        lastPageMessage: _aui.I18n.getText('bitbucket.web.entity.allfetched'),
        loading: false,
        loadMoreMessage: _aui.I18n.getText('bitbucket.web.entity.loadmore'),
        noItemsMessage: _aui.I18n.getText('bitbucket.web.entity.nonefound'),
        filterPlaceholder: _aui.I18n.getText('bitbucket.web.entity.filter.placeholder'),
        filterVisible: false,
        scrollElement: window,
        scrollToLoad: true,
        shouldScrollOnFocus: true,
        showTableIfNoResults: true,
        showSelectFilter: false,
        refreshOnFilterReset: false,
        showEmptyStateWithFilter: false
    };
    exports.default = FilterableEntityTable;

    var FilterInput = function (_PureComponent2) {
        _inherits(FilterInput, _PureComponent2);

        function FilterInput() {
            _classCallCheck(this, FilterInput);

            return _possibleConstructorReturn(this, (FilterInput.__proto__ || Object.getPrototypeOf(FilterInput)).apply(this, arguments));
        }

        _createClass(FilterInput, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                if (this.props.focused) {
                    this.input.focus();
                }
            }
        }, {
            key: 'componentDidUpdate',
            value: function componentDidUpdate(_ref5) {
                var focused = _ref5.focused;

                if (this.props.focused && !focused) {
                    //Only trigger a `.focus` if the element wasn't already focused
                    this.input.focus();
                }
            }
        }, {
            key: 'componentWillUnmount',
            value: function componentWillUnmount() {
                if (this.props.onBlur) {
                    this.props.onBlur();
                }
            }
        }, {
            key: 'render',
            value: function render() {
                var _this4 = this;

                var _props2 = this.props,
                    onKeyDown = _props2.onKeyDown,
                    onInput = _props2.onInput,
                    onFocus = _props2.onFocus,
                    onBlur = _props2.onBlur,
                    placeholder = _props2.placeholder,
                    disabled = _props2.disabled,
                    value = _props2.value;


                return _react2.default.createElement('input', {
                    className: 'paged-table-filter-input',
                    onBlur: onBlur,
                    onFocus: onFocus,
                    onInput: onInput,
                    onKeyDown: onKeyDown,
                    placeholder: placeholder,
                    ref: function ref(input) {
                        _this4.input = input;
                    },
                    disabled: disabled
                });
            }
        }]);

        return FilterInput;
    }(_react.PureComponent);

    var FilterSelect = function (_PureComponent3) {
        _inherits(FilterSelect, _PureComponent3);

        function FilterSelect() {
            _classCallCheck(this, FilterSelect);

            return _possibleConstructorReturn(this, (FilterSelect.__proto__ || Object.getPrototypeOf(FilterSelect)).apply(this, arguments));
        }

        _createClass(FilterSelect, [{
            key: 'componentDidMount',
            value: function componentDidMount() {
                var defaults = {
                    minimumResultsForSearch: -1 // don't show the search box.
                };
                var $filter = this.get$Input();
                $filter.auiSelect2((0, _lodash.assign)(defaults, { items: this.props.items }));
                $filter.on('change', this.props.onChange);
            }
        }, {
            key: 'get$Input',
            value: function get$Input() {
                return (0, _jquery2.default)(_reactDom2.default.findDOMNode(this)).children('select');
            }
        }, {
            key: 'render',
            value: function render() {
                return _react2.default.createElement(
                    'span',
                    { className: 'paged-table-filter-select' },
                    _react2.default.createElement(
                        'label',
                        { htmlFor: this.props.id, className: 'assistive' },
                        this.props.label
                    ),
                    _react2.default.createElement(
                        'select',
                        { id: this.props.id, value: this.props.value, readOnly: true },
                        this.props.items.map(function (item) {
                            return _react2.default.createElement(
                                'option',
                                { key: item.id, value: item.id, disabled: item.disabled },
                                item.text
                            );
                        })
                    )
                );
            }
        }]);

        return FilterSelect;
    }(_react.PureComponent);

    FilterSelect.propTypes = {
        id: _propTypes2.default.string,
        label: _propTypes2.default.string.isRequired,
        items: _propTypes2.default.arrayOf(_propTypes2.default.shape({
            id: _propTypes2.default.string.isRequired,
            text: _propTypes2.default.string.isRequired,
            disabled: _propTypes2.default.bool
        })).isRequired,
        onChange: _propTypes2.default.func.isRequired,
        value: _propTypes2.default.string.isRequired
    };
    FilterSelect.defaultProps = {
        id: 'entity-select-filter'
    };
});