define('bitbucket/internal/widget/filterable-entity-table/selectors', ['exports', 'icepick', 'lodash', 'reselect'], function (exports, _icepick, _lodash, _reselect) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.getStateForEntity = exports.getRequestFailedForEntity = exports.getLoadingForEntity = exports.getFilterableForEntity = exports.getEntitiesForEntity = exports.getCurrentPagingForEntity = exports.getCurrentFilterForEntity = exports.getCurrentSelectFilterForEntity = undefined;
    var getCurrentSelectFilterForEntity = exports.getCurrentSelectFilterForEntity = function getCurrentSelectFilterForEntity(entity) {
        return function (state) {
            return (0, _lodash.get)(state, ['ui', entity, 'selectFilter']);
        };
    };
    var getCurrentFilterForEntity = exports.getCurrentFilterForEntity = function getCurrentFilterForEntity(entity) {
        return function (state) {
            return (0, _lodash.get)(state, ['ui', entity, 'filter']);
        };
    };
    // paging is now with select filter concatenated with search filter - refer store.js
    var getCurrentPagingForEntity = exports.getCurrentPagingForEntity = function getCurrentPagingForEntity(entity) {
        return function (state) {
            return (0, _lodash.get)(state, ['paging', entity, '' + getCurrentSelectFilterForEntity(entity)(state) + getCurrentFilterForEntity(entity)(state)]);
        };
    };
    var getEntitiesForEntity = exports.getEntitiesForEntity = function getEntitiesForEntity(entity) {
        return function (state) {
            return (0, _lodash.get)(state, ['entities', entity]);
        };
    };
    var getFilterableForEntity = exports.getFilterableForEntity = function getFilterableForEntity(entity) {
        return function (state) {
            return (0, _lodash.get)(state, ['ui', entity, 'filterable']);
        };
    };
    var getLoadingForEntity = exports.getLoadingForEntity = function getLoadingForEntity(entity) {
        return function (state) {
            return (0, _lodash.get)(state, ['ui', entity, 'loading']);
        };
    };
    var getRequestFailedForEntity = exports.getRequestFailedForEntity = function getRequestFailedForEntity(entity) {
        return function (state) {
            return (0, _lodash.get)(state, ['ui', entity, 'requestFailed']);
        };
    };
    var getStateForEntity = exports.getStateForEntity = function getStateForEntity(entity) {
        return (0, _reselect.createSelector)([getEntitiesForEntity(entity), getCurrentSelectFilterForEntity(entity), getCurrentFilterForEntity(entity), getFilterableForEntity(entity), getLoadingForEntity(entity), getRequestFailedForEntity(entity), getCurrentPagingForEntity(entity)], function () {
            var entities = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
            var selectFilter = arguments[1];
            var filter = arguments[2];
            var filterable = arguments[3];
            var loading = arguments[4];
            var requestFailed = arguments[5];

            var _ref = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : {},
                _ref$ids = _ref.ids,
                ids = _ref$ids === undefined ? [] : _ref$ids,
                _ref$lastPageMeta = _ref.lastPageMeta;

            _ref$lastPageMeta = _ref$lastPageMeta === undefined ? {} : _ref$lastPageMeta;
            var isLastPage = _ref$lastPageMeta.isLastPage,
                limit = _ref$lastPageMeta.limit,
                nextPageStart = _ref$lastPageMeta.nextPageStart;
            return (0, _icepick.freeze)({
                entities: ids.map(function (id) {
                    return entities[id];
                }),
                selectFilter: selectFilter,
                filter: filter,
                filterable: filterable,
                isLastPage: requestFailed || isLastPage,
                limit: limit,
                loading: loading,
                nextPageStart: nextPageStart
            });
        });
    };
});