define('bitbucket/internal/widget/filterable-entity-table/store', ['module', 'exports', 'lodash', 'redux', 'bitbucket/internal/util/redux', 'bitbucket/internal/util/store/reducers', './actions'], function (module, exports, _lodash, _redux, _redux2, _reducers, _actions) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.default = createStore;

    function _defineProperty(obj, key, value) {
        if (key in obj) {
            Object.defineProperty(obj, key, {
                value: value,
                enumerable: true,
                configurable: true,
                writable: true
            });
        } else {
            obj[key] = value;
        }

        return obj;
    }

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    var NO_FILTER = '';

    function createStore(_ref) {
        var _ref$actors = _ref.actors,
            actors = _ref$actors === undefined ? [] : _ref$actors,
            _ref$entityName = _ref.entityName,
            entityName = _ref$entityName === undefined ? 'ENTITY' : _ref$entityName,
            entityIdField = _ref.entityIdField,
            _ref$loadAction = _ref.loadAction,
            loadAction = _ref$loadAction === undefined ? _actions.LOAD_ENTITIES : _ref$loadAction,
            _ref$loadSingleAction = _ref.loadSingleAction,
            loadSingleAction = _ref$loadSingleAction === undefined ? _actions.LOAD_SINGLE_ENTITY : _ref$loadSingleAction,
            _ref$deleteAction = _ref.deleteAction,
            deleteAction = _ref$deleteAction === undefined ? _actions.DELETE_ENTITY : _ref$deleteAction,
            _ref$initialFilter = _ref.initialFilter,
            initialFilter = _ref$initialFilter === undefined ? {} : _ref$initialFilter;

        var loadPageSuccess = loadAction + '_SUCCESS';
        var loadPageFailure = loadAction + '_FAILURE';
        var loadSingleSuccess = loadSingleAction + '_SUCCESS';
        var deleteSingleSuccess = deleteAction + '_SUCCESS';

        var _initialFilter$filter = initialFilter.filter,
            initialFilterInput = _initialFilter$filter === undefined ? NO_FILTER : _initialFilter$filter,
            _initialFilter$select = initialFilter.selectFilter,
            initialSelectFilter = _initialFilter$select === undefined ? NO_FILTER : _initialFilter$select;


        // paging is now with select filter concatenated with search filter
        var byFilter = (0, _reducers.keyBy)(function (action) {
            return action.type === loadPageSuccess ? '' + (0, _lodash.get)(action, 'meta.selectFilter', NO_FILTER) + (0, _lodash.get)(action, 'meta.filter', NO_FILTER) : null;
        });

        return _redux2.createActorStore.apply(undefined, [{
            entities: (0, _redux.combineReducers)(_defineProperty({}, entityName, (0, _reducers.entitiesReducer)({ loadPageSuccess: loadPageSuccess, loadSingleSuccess: loadSingleSuccess, deleteSingleSuccess: deleteSingleSuccess }, entityIdField))),
            paging: (0, _redux.combineReducers)(_defineProperty({}, entityName, (0, _reducers.reduceByTypes)({}, new Map([[[deleteSingleSuccess, loadSingleSuccess], function () {
                return {};
            }], [loadPageSuccess, byFilter((0, _reducers._legacyPagingReducer)(loadPageSuccess, entityIdField))]])))),
            ui: (0, _redux.combineReducers)(_defineProperty({}, entityName, (0, _redux.combineReducers)({
                loading: (0, _reducers.toggleReducer)({
                    on: [loadAction],
                    off: [loadPageSuccess, loadPageFailure]
                }),
                filter: (0, _reducers.reduceByType)(initialFilterInput, _defineProperty({}, _actions.FILTER_CHANGED, function (state, _ref2) {
                    var _ref2$payload = _ref2.payload,
                        filter = _ref2$payload === undefined ? initialFilterInput : _ref2$payload;
                    return filter;
                })),
                selectFilter: (0, _reducers.reduceByType)(initialSelectFilter, _defineProperty({}, _actions.SELECT_FILTER_CHANGED, function (_, _ref3) {
                    var _ref3$payload = _ref3.payload,
                        filter = _ref3$payload === undefined ? initialSelectFilter : _ref3$payload;
                    return filter;
                })),
                requestFailed: (0, _reducers.toggleReducer)({ on: [loadPageFailure] })
            })))
        }, {}].concat(_toConsumableArray(actors)));
    }
    module.exports = exports['default'];
});