define('bitbucket/internal/widget/icons/icons-factory', ['exports', 'classnames', 'lodash', 'prop-types', 'react', 'bitbucket/internal/bbui/tipsy/tipsy'], function (exports, _classnames, _lodash, _propTypes, _react, _tipsy) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.svgIconFactory = exports.iconfontIconFactory = undefined;

    var _classnames2 = _interopRequireDefault(_classnames);

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    var _tipsy2 = _interopRequireDefault(_tipsy);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    function _objectWithoutProperties(obj, keys) {
        var target = {};

        for (var i in obj) {
            if (keys.indexOf(i) >= 0) continue;
            if (!Object.prototype.hasOwnProperty.call(obj, i)) continue;
            target[i] = obj[i];
        }

        return target;
    }

    var getIconDisplayName = function getIconDisplayName(iconName) {
        return (0, _lodash.upperFirst)((0, _lodash.camelCase)(iconName)) + 'Icon\'';
    };

    var propTypes = {
        className: _propTypes2.default.string,
        children: _propTypes2.default.node,
        size: _propTypes2.default.oneOf(['small', 'large']),
        tooltip: _propTypes2.default.bool
    };

    var sizeClassMap = {
        small: 'aui-icon-small',
        large: 'aui-icon-large'
    };

    var getSizeClassName = function getSizeClassName(size) {
        return sizeClassMap[size] || sizeClassMap['small'];
    };

    var iconfontIconFactory = function iconfontIconFactory(iconName) {
        var Icon = function Icon(_ref) {
            var className = _ref.className,
                children = _ref.children,
                _ref$size = _ref.size,
                size = _ref$size === undefined ? 'small' : _ref$size,
                _ref$tooltip = _ref.tooltip,
                tooltip = _ref$tooltip === undefined ? false : _ref$tooltip,
                props = _objectWithoutProperties(_ref, ['className', 'children', 'size', 'tooltip']);

            var iconClassName = (0, _classnames2.default)('aui-icon', getSizeClassName(size), 'aui-iconfont-' + iconName, className);

            return tooltip ? _react2.default.createElement(
                _tipsy2.default,
                _extends({ className: iconClassName }, props),
                children
            ) : _react2.default.createElement(
                'span',
                _extends({ className: iconClassName }, props),
                children
            );
        };

        Icon.propTypes = _extends({}, propTypes);
        Icon.displayName = getIconDisplayName(iconName);

        return (0, _react.memo)(Icon);
    };

    exports.iconfontIconFactory = iconfontIconFactory;
    var svgIconFactory = function svgIconFactory(iconName) {
        var svgIconClassName = 'icon-' + iconName;

        var Icon = function Icon(_ref2) {
            var className = _ref2.className,
                children = _ref2.children,
                _ref2$size = _ref2.size,
                size = _ref2$size === undefined ? 'small' : _ref2$size,
                _ref2$tooltip = _ref2.tooltip,
                tooltip = _ref2$tooltip === undefined ? false : _ref2$tooltip,
                props = _objectWithoutProperties(_ref2, ['className', 'children', 'size', 'tooltip']);

            var iconClassName = (0, _classnames2.default)('aui-icon', getSizeClassName(size), svgIconClassName, className);

            return tooltip ? _react2.default.createElement(
                _tipsy2.default,
                _extends({ className: iconClassName }, props),
                children
            ) : _react2.default.createElement(
                'span',
                _extends({ className: iconClassName }, props),
                children
            );
        };

        Icon.propTypes = _extends({}, propTypes);
        Icon.displayName = getIconDisplayName(iconName);

        return (0, _react.memo)(Icon);
    };
    exports.svgIconFactory = svgIconFactory;
});