define("bitbucket/internal/widget/image-explorer/image-explorer",["module","exports","@atlassian/aui","jquery","lodash"],function(p,l,q,g,h){function b(a,b){this.init.apply(this,arguments)}Object.defineProperty(l,"__esModule",{value:!0});var m=function(a){if(a&&a.__esModule)return a;var b={};if(null!=a)for(var c in a)Object.prototype.hasOwnProperty.call(a,c)&&(b[c]=a[c]);b.default=a;return b}(q),n=g&&g.__esModule?g:{default:g},k=h&&h.__esModule?h:{default:h};b.scaleModes={fill:"fill",contain:"contain",
containAndFill:"containAndFill"};b.zoomModes={localZoom:"localZoom",imageZoom:"imageZoom"};b.maskShapes={CIRCLE:"circle",SQUARE:"square",ROUNDED_SQUARE:"rounded-square"};b.prototype.defaults={initialScaleMode:b.scaleModes.containAndFill,zoomMode:b.zoomModes.localZoom,emptyClass:"empty",scaleMax:1};b.prototype.init=function(a,b){this.$container=a;this.$imageView=this.$container.find(".image-explorer-image-view");this.$sourceImage=this.$container.find(".image-explorer-source");this.$mask=this.$container.find(".image-explorer-mask");
this.$dragDelegate=this.$container.find(".image-explorer-drag-delegate");this.$scaleSlider=this.$container.find(".image-explorer-scale-slider");this.options=n.default.extend({},this.defaults,b);this.imageProperties={};k.default.bindAll(this,"getImageSrc","setImageSrc","initImage","initDragDelegate","initScaleSlider","setInitialScale","getFillScale","getContainedScale","getCircularContainedScale","sliderValToScale","scaleToSliderVal","updateImageScale","resetImagePosition","resetScaleSlider","toggleEmpty",
"get$ImageView","get$SourceImage","get$Mask","get$DragDelegate","getMaskedImageProperties","showError","clearError","hasValidImage","_resetFromError","_removeError");this.toggleEmpty(!0);this.$sourceImage[0].naturalWidth&&(this.toggleEmpty(!1),this.initImage({target:this.$sourceImage[0]}));this.$sourceImage.on("load",this.initImage);this.initDragDelegate();this.initScaleSlider()};b.prototype.getImageSrc=function(){return this.$sourceImage?this.$sourceImage.attr("src"):void 0};b.prototype.setImageSrc=
function(a){this.$sourceImage&&(this.$sourceImage.attr("src",""),a?this.$sourceImage.attr("src",a):this.toggleEmpty(!0))};b.prototype.initImage=function(a){a=a.target;this.imageProperties.naturalWidth=a.naturalWidth;this.imageProperties.naturalHeight=a.naturalHeight;this._removeError();this.toggleEmpty(!1);this.setInitialScale()};b.prototype.initDragDelegate=function(){var a;this.$dragDelegate.draggable({start:k.default.bind(function(){a=this.$sourceImage.offset()},this),drag:k.default.bind(function(b,
c){this.$sourceImage.offset({top:a.top+c.position.top-c.originalPosition.top,left:a.left+c.position.left-c.originalPosition.left})},this),revert:!0,revertDuration:0})};b.prototype.initScaleSlider=function(){this.$scaleSlider.on("change input",k.default.bind(function(a){a=this.sliderValToScale(a.target.value);this.updateImageScale(a)},this))};b.prototype.setInitialScale=function(){var a=this.$mask.width(),f=this.$mask.height(),c=this.imageProperties.naturalWidth,d=this.imageProperties.naturalHeight,
e=1;this.minScale=1;switch(this.options.initialScaleMode){case b.scaleModes.fill:this.minScale=e=this.getFillScale(c,d,a,f);break;case b.scaleModes.contain:this.$mask.hasClass("circle-mask")?this.minScale=e=this.getCircularContainedScale(c,d,a/2):this.minScale=e=this.getContainedScale(c,d,a,f);break;case b.scaleModes.containAndFill:this.$mask.hasClass("circle-mask")?this.minScale=this.getCircularContainedScale(c,d,a/2):this.minScale=this.getContainedScale(c,d,a,f),e=this.getFillScale(c,d,a,f)}this.maxScale=
Math.max(e,this.options.scaleMax);this.resetScaleSlider(this.scaleToSliderVal(e));this.updateImageScale(e,b.zoomModes.imageZoom);this.resetImagePosition()};b.prototype.getFillScale=function(a,b,c,d){return Math.max(c/a,d/b)};b.prototype.getContainedScale=function(a,b,c,d){return Math.min(c/a,d/b)};b.prototype.getCircularContainedScale=function(a,b,c){return Math.cos(Math.atan(b/a))*c*2/a};b.prototype.sliderValToScale=function(a){var b=this.$scaleSlider.attr("max"),c=this.$scaleSlider.attr("min");
return this.minScale+a/(b-c)*(this.maxScale-this.minScale)};b.prototype.scaleToSliderVal=function(a){return(a-this.minScale)/(this.maxScale-this.minScale)*(this.$scaleSlider.attr("max")-this.$scaleSlider.attr("min"))};b.prototype.updateImageScale=function(a,f){var c=Math.round(a*this.imageProperties.naturalWidth);a=Math.round(a*this.imageProperties.naturalHeight);f=f||this.options.zoomMode;switch(f){case b.zoomModes.imageZoom:var d=-1*c/2;var e=-1*a/2;break;case b.zoomModes.localZoom:d=this.$sourceImage.width();
f=this.$sourceImage.height();var k=parseInt(this.$sourceImage.css("margin-left"),10),g=parseInt(this.$sourceImage.css("margin-top"),10);e=this.$sourceImage.position();var h=this.$imageView.width()/2,l=this.$imageView.height()/2;g=l-e.top-g;d=h-e.left-(h-e.left-k)/d*c;e=l-e.top-g/f*a}this.$sourceImage.width(c).height(a).css({"margin-left":Math.round(d)+"px","margin-top":Math.round(e)+"px"})};b.prototype.resetImagePosition=function(){this.$sourceImage.css({top:"50%",left:"50%"})};b.prototype.resetScaleSlider=
function(a){this.$scaleSlider.val(a).removeClass("disabled").prop("disabled",!1)};b.prototype.toggleEmpty=function(a){this.$container.toggleClass(this.options.emptyClass,a)};b.prototype.get$ImageView=function(){return this.$imageView};b.prototype.get$SourceImage=function(){return this.$sourceImage};b.prototype.get$Mask=function(){return this.$mask};b.prototype.get$DragDelegate=function(){return this.$dragDelegate};b.prototype.getMaskedImageProperties=function(){var a=this.$sourceImage.width()/this.imageProperties.naturalWidth,
b=this.$sourceImage.height()/this.imageProperties.naturalHeight,c=this.$mask.position(),d=this.$sourceImage.position();c.top+=parseInt(this.$mask.css("margin-top"),10);c.left+=parseInt(this.$mask.css("margin-left"),10);d.top+=parseInt(this.$sourceImage.css("margin-top"),10);d.left+=parseInt(this.$sourceImage.css("margin-left"),10);return{maskedAreaImageX:Math.round((c.left-d.left)/a),maskedAreaImageY:Math.round((c.top-d.top)/b),maskedAreaWidth:Math.round(this.$mask.width()/a),maskedAreaHeight:Math.round(this.$mask.height()/
b)}};b.prototype.showError=function(a,b){this._removeError();this.toggleEmpty(!0);this.$container.addClass("error");a=(0,n.default)(aui.message.error({titleContent:m.escapeHtml(a),content:b||"",isCloseable:!0}));a.appendTo(this.$imageView).css({"margin-top":-1*a.outerHeight()/2});a.on("messageClose",this._resetFromError);m.messages.setup()};b.prototype.clearError=function(){this._removeError();this._resetFromError()};b.prototype.hasValidImage=function(){return!(!this.getImageSrc()||!this.$sourceImage.prop("naturalWidth"))};
b.prototype._resetFromError=function(){var a=this.hasValidImage();this.toggleEmpty(!a);this.$container.removeClass("error");k.default.isFunction(this.options.onErrorReset)&&this.options.onErrorReset(a?this.getImageSrc():void 0)};b.prototype._removeError=function(){this.$imageView.find(".aui-message-error").remove()};l.default=b;p.exports=l["default"]});