define('bitbucket/internal/widget/resource-utilization-graph/resource-utilization-graph', ['module', 'exports', 'prop-types', 'react', 'atlaskit-colors'], function (module, exports, _propTypes, _react, _atlaskitColors) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    var _propTypes2 = _interopRequireDefault(_propTypes);

    var _react2 = _interopRequireDefault(_react);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var graphBarColor = function graphBarColor(stops, value) {
        return (
            // Find the largest stop that is less than the value
            stops[Object.keys(stops).map(function (x) {
                return parseInt(x);
            }).sort().reverse().find(function (stopValue) {
                return value >= stopValue;
            })]
        );
    };

    var ResourceUtilizationGraph = function ResourceUtilizationGraph(_ref) {
        var usedPercentage = _ref.usedPercentage,
            _ref$stops = _ref.stops,
            stops = _ref$stops === undefined ? { 0: _atlaskitColors.akColorN500, 75: _atlaskitColors.akColorY300, 99: _atlaskitColors.akColorR300 } : _ref$stops;
        return _react2.default.createElement(
            'div',
            { className: 'resource-graph-container' },
            _react2.default.createElement('div', {
                className: 'resource-graph-bar',
                style: {
                    width: usedPercentage + '%',
                    backgroundColor: graphBarColor(stops, usedPercentage)
                }
            })
        );
    };

    ResourceUtilizationGraph.propTypes = {
        usedPercentage: _propTypes2.default.number.isRequired,
        stops: _propTypes2.default.object
    };

    exports.default = ResourceUtilizationGraph;
    module.exports = exports['default'];
});