(function(window) {
    /* global require: true, define: true */

    'use strict';

    // Almond claims to be AMD compatible, but isn't.
    delete define.amd;

    var oldRequire = require;
    require = function(modules, cb) {
        //only allow the use of a callback as the second param, don't expose any other almond internal params.
        //https://github.com/requirejs/almond/blob/0.3.0/almond.js#L337
        if (cb && typeof cb !== 'function') {
            cb = undefined;
        }
        return oldRequire.call(window, modules, cb);
    };

    var oldDefine = define;
    define = function(name, deps, callback) {
        // duplicate logic from Almond to check if deps is a callback (ie. no dependencies)
        if (!deps.splice) {
            //deps is not an array, so probably means
            //an object literal or factory function for
            //the value. Adjust args.
            callback = deps;
            deps = [];
        }

        var requireIndex = deps.indexOf('require');
        if (requireIndex !== -1) {
            var oldCallback = callback;
            callback = function() {
                var oldRequire = arguments[requireIndex];
                arguments[requireIndex] = function(modules) {
                    return oldRequire.apply(this, arguments);
                };
                return oldCallback.apply(this, arguments);
            };
        }

        return oldDefine.call(window, name, deps, callback);
    };

    window.requireLite = require; // Used for testing
    window.defineLite = define; // Used for testing
})(window || this);
