define('bitbucket-plugin-repository-shortcuts/internal/feature/repository-shortcuts/generate-label-from-url', ['module', 'exports', 'lodash'], function (module, exports, _lodash) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });

    exports.default = function (url) {
        if ((0, _lodash.startsWith)('https', url)) {
            // if they're in the process of writing http or https, don't set a default label.
            // wait for them to get to the domain name.
            return '';
        }
        var colonMatch = /:(\/\/)?/.exec(url);

        if (!colonMatch) {
            return url;
        }

        var domainStart = colonMatch.index + colonMatch[0].length;
        var domainEnd = url.indexOf('/', domainStart);

        return url.substring(domainStart, domainEnd === -1 ? undefined : domainEnd);
    };

    module.exports = exports['default'];
});