define('bitbucket-plugin-repository-shortcuts/internal/feature/repository-shortcuts/repository-shortcuts', ['exports', '@atlassian/aui', 'jquery', 'lodash', 'bitbucket/internal/util/analytics', 'bitbucket/internal/util/dom-event', 'bitbucket/internal/util/promise', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state', './generate-label-from-url'], function (exports, _aui, _jquery, _lodash, _analytics, _domEvent, _promise, _navbuilder, _server, _state, _generateLabelFromUrl) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.onReady = onReady;

    var AJS = _interopRequireWildcard(_aui);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _lodash2 = _interopRequireDefault(_lodash);

    var analytics = _interopRequireWildcard(_analytics);

    var _domEvent2 = _interopRequireDefault(_domEvent);

    var _promise2 = _interopRequireDefault(_promise);

    var nav = _interopRequireWildcard(_navbuilder);

    var server = _interopRequireWildcard(_server);

    var _state2 = _interopRequireDefault(_state);

    var _generateLabelFromUrl2 = _interopRequireDefault(_generateLabelFromUrl);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    var _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (Object.prototype.hasOwnProperty.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target;
    };

    var addShortcutDialogId = 'add-shortcut-dialog';
    var editShortcutClass = 'edit-shortcut';
    var deleteShortcutClass = 'delete-shortcut';

    // The maxVisibleWhenCollapsed here is currently tied to `visibleCount` in entity.soy
    // Don't update one without the other.
    var maxVisibleWhenCollapsed = 4;

    var $featuredItems = void 0;
    var $featuredItemsNav = void 0;
    var $overflowItems = void 0;
    var $overflowItemsNav = void 0;

    var shortcutRestUrlBuilder = nav.rest('repository-shortcuts').repository(_state2.default.getRepository()).addPathComponents('shortcuts');

    var extractShortcut = function extractShortcut($shortcut) {
        return {
            id: $shortcut.attr('id').split('-').pop(),
            url: $shortcut.attr('href'),
            label: $shortcut.find('.aui-nav-item-label').text()
        };
    };

    var extractShortcutFields = function extractShortcutFields($form) {
        return {
            url: $form.find('#shortcut-form-url').val(),
            label: $form.find('#shortcut-form-label').val()
        };
    };

    var fireAnalytics = function fireAnalytics(e) {
        analytics.add('stash.client.repository.shortcut.clicked', {
            openInSameTab: _domEvent2.default.openInSameTab(e),
            repositoryId: _state2.default.getRepository().id,
            shortcutId: extractShortcut((0, _jquery2.default)(e.currentTarget)).id
        });
    };

    var indicateSubmitting = function indicateSubmitting($button, promise) {
        //disable the submit button
        var toggleDisabled = function toggleDisabled(val) {
            return $button.prop('disabled', val);
        };
        toggleDisabled(true);
        promise.then(function () {
            return toggleDisabled(false);
        }, function () {
            return toggleDisabled(false);
        });

        //and show a spinner
        return _promise2.default.spinner($button.siblings('.button-spinner'), promise, null, null, Boolean('keep'));
    };

    var statusCodesToIgnore = [0, 401];

    // This code must match com.atlassian.bitbucket.internal.repository.shortcut.web.RepositoryShortcutWebItemProvider::getIconType
    var getIconClass = function getIconClass(productType) {
        switch (productType) {
            case 'BAMBOO':
                return 'icon-bamboo';
            case 'BITBUCKET_CLOUD':
                return 'icon-bitbucket';
            case 'BITBUCKET_SERVER':
                return 'icon-bitbucket';
            case 'CONFLUENCE':
                return 'icon-confluence';
            case 'HIPCHAT':
                return 'icon-hipchat';
            case 'JIRA':
                return 'icon-jira';
            case 'TRELLO':
                return 'icon-trello';
            default:
                return 'icon-link';
        }
    };

    /**
     * Add a shortcut
     * @param {jQuery} $dialog - the dialog being submitted
     * @returns {Promise}
     */
    var addShortcut = function addShortcut($dialog) {
        clearErrors($dialog);

        return server.rest({
            url: shortcutRestUrlBuilder.build(),
            type: 'POST',
            data: extractShortcutFields($dialog),
            statusCode: {
                0: true,
                401: true,
                '*': false
            }
        }).done(renderShortcutWebItem).fail(handleErrors($dialog.find('form'), statusCodesToIgnore));
    };

    /**
     * Edit a shortcut
     * @param {{url, label, id}} shortcut - details about the shortcut
     * @param {jQuery} $shortcut - the shortcut <a> tag in the sidebar
     * @param {jQuery} $dialog - the dialog being submitted
     * @returns {Promise}
     */
    var editShortcut = function editShortcut(shortcut, $shortcut, $dialog) {
        clearErrors($dialog);

        return server.rest({
            url: shortcutRestUrlBuilder.addPathComponents(shortcut.id).build(),
            type: 'PUT',
            data: extractShortcutFields($dialog),
            statusCode: {
                0: true,
                401: true,
                '*': false
            }
        }).done(function (_ref) {
            var url = _ref.url,
                label = _ref.label,
                productType = _ref.productType;

            $shortcut.attr('href', url);
            $shortcut.find('.aui-nav-item-label').text(label);
            $shortcut.find('.aui-icon').prop('className', 'aui-icon aui-icon-small ' + getIconClass(productType));
        }).fail(handleErrors($dialog.find('form'), statusCodesToIgnore));
    };

    /**
     * Delete a shortcut
     * @param {{url, label, id}} shortcut - details about the shortcut
     * @param {jQuery} $shortcut - the shortcut <a> tag in the sidebar
     * @param {jQuery} $dialog - the dialog being submitted
     * @returns {Promise}
     */
    var deleteShortcut = function deleteShortcut(shortcut, $shortcut, $dialog) {
        return server.rest({
            url: shortcutRestUrlBuilder.addPathComponents(shortcut.id).build(),
            type: 'DELETE',
            statusCode: { 404: false }
        }).then(null, function (xhr) {
            if (xhr.status === 404) {
                // silently succeed if the shortcut doesn't exist.
                return _jquery2.default.Deferred().resolve();
            }

            return _jquery2.default.Deferred().reject();
        }).done(function () {
            return removeShortcutFromSidebar($shortcut.closest('li'));
        });
    };

    var resetAddShortcutForm = function resetAddShortcutForm($dialog) {
        // A workaround for resetting the form values and validation state
        $dialog.find('.repo-shortcut-form')[0].reset();
        $dialog.find('.error, .aui-message-error').remove();
        $dialog.find('input.text').each(function () {
            (0, _jquery2.default)(this).removeAttr('data-aui-notification-error').attr('data-aui-validation-state', 'unvalidated');
        });
    };

    var initAddShortcut = function initAddShortcut() {
        var $trigger = (0, _jquery2.default)('#add-repo-shortcut-trigger');
        $trigger.attr({
            'aria-controls': addShortcutDialogId,
            'data-aui-trigger': ''
        });
        // Overriding the wrong value set by AUI
        setTimeout(function () {
            return $trigger.attr('aria-haspopup', 'dialog');
        });

        var timer = void 0;
        var $dialog = (0, _jquery2.default)(bitbucketPluginRepositoryShortcuts.internal.feature.repositoryShortcuts.repositoryShortcuts.addDialog({
            alignment: 'right bottom',
            dialogId: addShortcutDialogId
        })).appendTo(document.body).on('aui-hide', function () {
            resetAddShortcutForm($dialog);
            $trigger.focus();
        }).on('keyup', 'input[type="text"]', function (e) {
            if (e.key === 'Tab') {
                return;
            }
            clearTimeout(timer);
            timer = stopTypingEventTrigger(e.target);
        }).on('click', '#add-shortcut-cancel', function (e) {
            e.preventDefault();
            $dialog.attr('open', false);
        }).on('aui-valid-submit', 'form', function (e) {
            e.preventDefault();
            indicateSubmitting((0, _jquery2.default)('#create-link'), addShortcut($dialog)).then(function () {
                return $dialog.attr('open', false);
            });
        });
        var $label = $dialog.find('#shortcut-form-label');
        var $url = $dialog.find('#shortcut-form-url');
        var updateDelayMs = 10;
        var maxLabelLen = 255;
        var updateLabel = _lodash2.default.debounce(function () {
            return $label.val((0, _generateLabelFromUrl2.default)($url.val()).substring(0, maxLabelLen));
        }, updateDelayMs);
        $url.on('input', updateLabel);
        $label.one('input', function () {
            return $url.off('input', updateLabel);
        });
    };

    var actionsToInit = [shortcutActionDialog('.' + editShortcutClass, function (shortcut) {
        return {
            idSuffix: '-edit-dialog',
            title: AJS.I18n.getText('bitbucket.repository.shortcut.edit.dialog.title'),
            content: soydata.VERY_UNSAFE.ordainSanitizedHtml(bitbucketPluginRepositoryShortcuts.internal.feature.repositoryShortcuts.repositoryShortcuts.dialogForm(shortcut))
        };
    }, editShortcut), shortcutActionDialog('.' + deleteShortcutClass, function (shortcut) {
        return {
            idSuffix: '-delete-dialog',
            isDestructive: true,
            title: AJS.I18n.getText('bitbucket.repository.shortcut.delete.dialog.title'),
            content: soydata.VERY_UNSAFE.ordainSanitizedHtml(bitbucketPluginRepositoryShortcuts.internal.feature.repositoryShortcuts.repositoryShortcuts.deleteDialogContent(shortcut)),
            submitLabel: AJS.I18n.getText('bitbucket.web.button.delete')
        };
    }, deleteShortcut)];
    var initActions = function initActions(menu) {
        return actionsToInit.forEach(function (initAction) {
            return initAction(menu);
        });
    };

    function addShortcutToSidebar($shortcut) {
        var currentFeatured = $featuredItemsNav.children().length;

        if (currentFeatured >= maxVisibleWhenCollapsed - 1) {
            if (currentFeatured >= maxVisibleWhenCollapsed) {
                $overflowItemsNav.append($featuredItemsNav.children().last());
            }
            if ($overflowItemsNav.children().length) {
                $overflowItemsNav.append($shortcut);
            } else {
                $featuredItemsNav.append($shortcut);
            }
        } else {
            $featuredItemsNav.append($shortcut);
        }
        updateSectionDisplay();
    }

    function removeShortcutFromSidebar($shortcut) {
        if ($shortcut.closest($overflowItemsNav).length) {
            // if we're in the overflow section
            $shortcut.remove();
        } else {
            $shortcut.remove();
            if ($featuredItemsNav.children().length === maxVisibleWhenCollapsed - 2) {
                $featuredItemsNav.append($overflowItemsNav.children().first());
            }
        }
        if ($overflowItemsNav.children().length === 1) {
            // don't leave a single item in overflow - put 4 in featured
            $featuredItemsNav.append($overflowItemsNav.children());
        }
        updateSectionDisplay();
    }

    function updateSectionDisplay() {
        $featuredItems.toggleClass('hidden-when-collapsed', !$featuredItemsNav.children().length);
        $overflowItems.toggleClass('hidden', !$overflowItemsNav.children().length);
    }

    /**
     * Fire a stop typing event on a given target.
     * @param {HTMLElement} target - The element to fire the stop typing event on.
     * @return {number} - The id of the timer
     */
    function stopTypingEventTrigger(target) {
        return setTimeout(function () {
            (0, _jquery2.default)(target).trigger('stop-typing');
        }, 200);
    }

    function shortcutActionDialog(triggerSelector, getDialogInfo, handleSubmit) {
        return function (menu) {
            var $menu = (0, _jquery2.default)(menu);
            var $trigger = $menu.find(triggerSelector);
            var $shortcut = (0, _jquery2.default)('#' + $menu.attr('data-web-item-id'));
            $trigger.on('click', function (e) {
                e.preventDefault();
                var shortcut = extractShortcut($shortcut);
                var dialogInfo = getDialogInfo(shortcut);
                var $dialog = (0, _jquery2.default)(bitbucketPluginRepositoryShortcuts.internal.feature.repositoryShortcuts.repositoryShortcuts.actionDialog(_extends({
                    id: $shortcut.attr('id') + dialogInfo.idSuffix,
                    submitLabel: AJS.I18n.getText('bitbucket.repository.shortcut.save')
                }, dialogInfo)));
                var $form = $dialog.find('form');
                var removeDialog = function removeDialog() {
                    return AJS.dialog2($dialog).remove();
                };

                var onSubmit = function onSubmit() {
                    return indicateSubmitting($dialog.find('.submit-dialog'), handleSubmit(shortcut, $shortcut, $dialog)).then(removeDialog);
                };
                var timer = void 0;
                $dialog.on('keyup', 'input[type="text"]', function (e) {
                    if (e.key === 'Tab') {
                        return;
                    }
                    clearTimeout(timer);
                    timer = stopTypingEventTrigger(e.target);
                }).on('aui-hide', _lodash2.default.debounce(function () {
                    var dialog = AJS.dialog2($dialog);

                    if (dialog.isVisible()) {
                        // avoid stack overflow - remove calls hide.
                        removeDialog();
                    }
                })).on('click', '.close-dialog', function () {
                    removeDialog();
                }).on('click', '.submit-dialog', function () {
                    $form.length ? $form.submit() : onSubmit();
                }).keypress(function (e) {
                    if (e.which === AJS.keyCode.ENTER && !(0, _jquery2.default)(document.activeElement).is('a, button')) {
                        $form.length ? $form.submit() : onSubmit();
                    }
                }).on('aui-valid-submit', 'form', function (e) {
                    e.preventDefault();
                    onSubmit();
                });
                if (dialogInfo.isDestructive) {
                    $dialog.on('aui-show', _lodash2.default.debounce(function () {
                        return $dialog.find('.close-dialog').focus();
                    }));
                }
                AJS.dialog2($dialog).show();
            });
        };
    }

    var renderShortcutWebItem = function renderShortcutWebItem(_ref2) {
        var id = _ref2.id,
            url = _ref2.url,
            label = _ref2.label,
            productType = _ref2.productType;

        var $newLink = (0, _jquery2.default)(bitbucketPluginRepositoryShortcuts.internal.feature.repositoryShortcuts.repositoryShortcuts.clientShortcut({
            id: id,
            url: url,
            label: label,
            iconClass: getIconClass(productType)
        })).on('mousedown', 'a', fireAnalytics);
        var $newLinkDialog = (0, _jquery2.default)(bitbucketPluginRepositoryShortcuts.internal.feature.repositoryShortcuts.repositoryShortcuts.clientShortcutDialog({
            id: id,
            url: url,
            label: label,
            moduleKey: 'bitbucket.web.sidebar.repository.nav.shortcut.' + id,
            actions: [{
                styleClass: editShortcutClass,
                linkText: AJS.I18n.getText('bitbucket.repository.shortcut.edit')
            }, {
                styleClass: deleteShortcutClass,
                linkText: AJS.I18n.getText('bitbucket.repository.shortcut.delete')
            }]
        }));

        addShortcutToSidebar($newLink);
        $newLinkDialog.insertAfter('.add-shortcut-panel').each(function (i, el) {
            return initActions(el);
        });
    };

    var clearErrors = function clearErrors($dialog) {
        $dialog.find('.aui-message-error').remove();
    };

    var handleErrors = function handleErrors($form, ignoredStatusCodes) {
        return function (xhr) {
            if (!_lodash2.default.includes(ignoredStatusCodes, xhr.status)) {
                $form.prepend(AJS.messages.error({
                    body: _lodash2.default.get(xhr, 'responseJSON.errors[0].message') || AJS.I18n.getText('bitbucket.repository.shortcut.error.unexpected'),
                    closeable: false
                }));
            }
        };
    };

    var initCustomValidation = function initCustomValidation() {
        _PageDataPlugin.ready('com.atlassian.bitbucket.server.bitbucket-repository-shortcuts:repository-shortcuts-url-scheme-whitelist-provider', 'bitbucket.layout.repository', function (data) {
            if (data) {
                AJS.formValidation.register(['repo-shortcut-url-scheme'], function (field) {
                    var val = field.el.value || '';
                    var hasScheme = _lodash2.default.includes(val, ':');

                    if (!hasScheme) {
                        field.invalidate(AJS.I18n.getText('bitbucket.repository.shortcut.error.no.scheme'));

                        return;
                    }
                    var hasValidScheme = data.urlSchemeWhitelist.some(function (scheme) {
                        return _lodash2.default.startsWith(val, scheme);
                    });

                    if (!hasValidScheme) {
                        field.invalidate(AJS.I18n.getText('bitbucket.repository.shortcut.error.invalid.scheme', /^.*?:(\/\/)?/.exec(val)[0]));
                    } else {
                        field.validate();
                    }
                });
            } else {
                console.warn('Could not find Repo Shortcut schemes. Is this code being loaded on the wrong page?');
            }
        });
    };

    function onReady() {
        $featuredItems = (0, _jquery2.default)('.section-featured-items[data-web-section-key="bitbucket.web.sidebar.repository.nav.shortcuts"]');
        $featuredItemsNav = $featuredItems.children('.aui-nav');
        $overflowItems = (0, _jquery2.default)('.section-overflow-items[data-web-section-key="bitbucket.web.sidebar.repository.nav.shortcuts"]');
        $overflowItemsNav = $overflowItems.children('.aui-nav');

        initAddShortcut();
        (0, _jquery2.default)('.sidebar-actions-dialog').each(function (i, el) {
            return initActions(el);
        });
        updateSectionDisplay();

        (0, _jquery2.default)('.aui-sidebar-group[data-web-section-key="bitbucket.web.sidebar.repository.nav.shortcuts"] > ul > li > a').on('mousedown', fireAnalytics);

        initCustomValidation();
    }
});