define('bitbucket-plugin-importer/internal/owner-selector/owner-selector', [
    '@atlassian/aui',
    'lodash',
], function (AJS, _) {
    /**
     * @param {Object} options
     * @param {Object} options.data - the data to populate the select2 with
     * @param {String|HtmlElement|jQuery} options.selector - the element reference/selector to attach the select to.
     * @param {Number} options.searchFieldThreshold - the threshold at which to show the search field.
     */
    function ownerSelector(options) {
        var data = options.data;
        // add an ID property to each item so Select2 has an ID to work with.
        data.results = data.results.map(function (item) {
            item.id = item.name;

            return item;
        });

        return AJS.$(options.selector).auiSelect2({
            minimumResultsForSearch:
                options.data.results.length < options.searchFieldThreshold ? -1 : 0,
            data: options.data,
            formatResult:
                bitbucketPluginImporter.internal.ownerSelector.ownerSelector.ownerSelectorItem,
            formatSelection:
                bitbucketPluginImporter.internal.ownerSelector.ownerSelector.ownerSelectorItem,
            initSelection: function (el, callback) {
                return callback(options.data.results[0]);
            },
            escapeMarkup: _.identity, // we do not want to escape markup since we are displaying html in results
            containerCssClass: 'owner-selector-container',
            dropdownCssClass: 'owner-selector-dropdown',
        });
    }

    return ownerSelector;
});
