define('bitbucket-plugin-git-rest/internal/feature/git-rest/pull-request/rebase/rebase-pull-request', ['exports', '@atlassian/aui', 'jquery', 'bitbucket/internal/enums', 'bitbucket/internal/util/notifications/notifications', 'bitbucket/internal/util/property', 'bitbucket/internal/widget/submit-spinner/submit-spinner', 'bitbucket/util/events', 'bitbucket/util/navbuilder', 'bitbucket/util/server', 'bitbucket/util/state'], function (exports, _aui, _jquery, _enums, _notifications, _property, _submitSpinner, _events, _navbuilder, _server, _state) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.webItemCondition = undefined;
    exports.onReady = onReady;

    var _jquery2 = _interopRequireDefault(_jquery);

    var notifications = _interopRequireWildcard(_notifications);

    var _property2 = _interopRequireDefault(_property);

    var _submitSpinner2 = _interopRequireDefault(_submitSpinner);

    var _events2 = _interopRequireDefault(_events);

    var nav = _interopRequireWildcard(_navbuilder);

    var _state2 = _interopRequireDefault(_state);

    function _interopRequireWildcard(obj) {
        if (obj && obj.__esModule) {
            return obj;
        } else {
            var newObj = {};

            if (obj != null) {
                for (var key in obj) {
                    if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
                }
            }

            newObj.default = obj;
            return newObj;
        }
    }

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    var buildRebaseUrl = function buildRebaseUrl() {
        return nav.rest('git').pullRequest(_state2.default.getPullRequest()).addPathComponents('rebase').build();
    };

    var flagBody = function flagBody(body) {
        return '<div class=\'rebase-flag-body\'>' + body + '</div>';
    };

    var getBranchLozenges = function getBranchLozenges(_ref) {
        var fromRef = _ref.fromRef,
            toRef = _ref.toRef;

        var isForkPR = fromRef.repository.id !== toRef.repository.id;

        return {
            fromLozenge: bitbucket.internal.feature.repository.refLozenge.refLozenge.refLozenge({
                extraClasses: 'rebase-ref-lozenge',
                ref: fromRef,
                repository: isForkPR ? fromRef.repository : null
            }),
            toLozenge: bitbucket.internal.feature.repository.refLozenge.refLozenge.refLozenge({
                extraClasses: 'rebase-ref-lozenge',
                ref: toRef,
                repository: isForkPR ? toRef.repository : null
            })
        };
    };

    var handle40X = function handle40X(exceptionName, bodyRenderer, error) {
        if (error.exceptionName === exceptionName) {
            (0, _aui.flag)({
                type: 'error',
                title: _aui.I18n.getText('bitbucket.git.pullrequest.rebase.failed.title'),
                body: flagBody(bodyRenderer(error))
            });

            return false;
        }
    };

    /**
     * Triggers a rebase for the pull request, rewriting unique commits on the incoming source branch against the
     * tip of the target branch.
     */
    var rebasePullRequest = function rebasePullRequest(pullRequest) {
        return _property2.default.getFromProvider('git.pull-request.rebase.timeout').then(function (timeout) {
            return (0, _server.rest)({
                data: {
                    version: pullRequest.version
                },
                statusCode: {
                    200: function _() {
                        var _getBranchLozenges = getBranchLozenges(pullRequest),
                            fromLozenge = _getBranchLozenges.fromLozenge,
                            toLozenge = _getBranchLozenges.toLozenge;

                        notifications.addFlash(_aui.I18n.getText('bitbucket.git.pullrequest.rebase.completed.title'), {
                            body: flagBody(_aui.I18n.getText('bitbucket.git.pullrequest.rebase.completed.body.html', fromLozenge, toLozenge))
                        });
                        document.location.reload();
                    },
                    204: function _() {
                        var _getBranchLozenges2 = getBranchLozenges(pullRequest),
                            fromLozenge = _getBranchLozenges2.fromLozenge,
                            toLozenge = _getBranchLozenges2.toLozenge;

                        (0, _aui.flag)({
                            close: 'auto',
                            type: 'info',
                            title: _aui.I18n.getText('bitbucket.git.pullrequest.rebase.skipped.title'),
                            body: flagBody(_aui.I18n.getText('bitbucket.git.pullrequest.rebase.skipped.body.html', fromLozenge, toLozenge))
                        });
                    },
                    400: function _(xhr, textStatus, errorThrown, _ref2) {
                        var errors = _ref2.errors;
                        return handle40X(
                        // Rebasing was successful, but the branch update was vetoed,
                        // most likely by a branch permission preventing history rewrite
                        'com.atlassian.bitbucket.hook.repository.RepositoryHookVetoedException', bitbucketPluginGitRest.internal.feature.gitRest.pullRequest.rebase.rebasePullRequest.vetoedBody, errors[0]);
                    },
                    409: function _(xhr, textStatus, errorThrown, _ref3) {
                        var errors = _ref3.errors;
                        return handle40X(
                        // Rebasing failed, either because one of the patches introduced conflicts, or because
                        // all of the patches to rebase were already present on the target branch
                        'com.atlassian.bitbucket.scm.git.command.rebase.GitRebaseException', function (error) {
                            return error.message;
                        }, errors[0]);
                    }
                },
                timeout: timeout * 1000,
                type: 'POST',
                url: buildRebaseUrl()
            });
        });
    };

    var rebaseIssueReason = function rebaseIssueReason() {
        var vetoes = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
        var conflicted = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

        var title = void 0;

        if (conflicted && !vetoes.length) {
            title = _aui.I18n.getText('bitbucket.git.pullrequest.rebase.conflict.tooltip');
        } else if (vetoes.length === 1 && !conflicted) {
            title = vetoes[0].detailedMessage;
        } else {
            title = _aui.I18n.getText('bitbucket.git.pullrequest.rebase.issue.tooltip');
        }

        return title;
    };

    var updateRebaseButton = function updateRebaseButton($button, canRebase) {
        var vetoes = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
        var conflicted = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

        var id = 'git-rebase-pull-request-details-dialog';

        if (!canRebase || conflicted) {
            $button.attr({
                'aria-disabled': true,
                'aria-controls': id, //Used to anchor the inline dialog that we open programmatically
                title: rebaseIssueReason(vetoes, conflicted)
            }).tooltip({
                gravity: 'e'
            });

            var oldDialog = document.getElementById(id);
            var $newDialog = (0, _jquery2.default)(bitbucketPluginGitRest.internal.feature.gitRest.pullRequest.rebase.rebasePullRequest.rebaseWarningDialog({
                conflicted: conflicted,
                id: id,
                vetoes: vetoes
            }));

            if (oldDialog) {
                $newDialog.replaceAll(oldDialog);
            } else {
                $newDialog.insertAfter($button);
            }

            $newDialog.on('click', '.more-info', function () {
                return _events2.default.trigger('bitbucket.internal.DO_NOT_USE.pull-request.show.cant.merge.help');
            });
        } else {
            $button.attr({
                'aria-disabled': null,
                'aria-controls': null,
                title: _aui.I18n.getText('bitbucket.git.pullrequest.rebase.tooltip')
            }).tooltip('destroy');
        }
    };

    var webItemCondition = exports.webItemCondition = function webItemCondition(context) {
        return context.pullRequest.state === _enums.PullRequestState.OPEN && context.pullRequest.toRef.repository.scmId === _enums.ScmType.GIT && context.conditions.canUpdateSourceBranch;
    };

    function onReady() {
        var $rebaseButton = (0, _jquery2.default)('.git-rebase-pull-request');

        if (!$rebaseButton.length) {
            return;
        }

        _events2.default.on('bitbucket.internal.DO_NOT_USE.pull-request.*.merge', function (pullRequest, conflicted) {
            return (0, _server.rest)({ url: buildRebaseUrl() }).always(function (_ref4) {
                var canRebase = _ref4.canRebase,
                    vetoes = _ref4.vetoes;
                return updateRebaseButton($rebaseButton, canRebase, vetoes, conflicted);
            });
        });

        $rebaseButton.on('click', function (e) {
            if (e.target.getAttribute('aria-disabled') === 'true') {
                var inlineDialog = document.getElementById(e.target.getAttribute('aria-controls'));

                //Disable tooltip so it doesn't hover over inline dialog
                $rebaseButton.tooltip('destroy');
                inlineDialog.open = true;
                (0, _jquery2.default)(inlineDialog).one('aui-hide', function () {
                    return $rebaseButton.tooltip();
                });

                //Don't allow the click to propagate and close the dropdown
                e.stopPropagation();

                return;
            }

            var pullRequest = _state2.default.getPullRequest();

            var dialog = (0, _aui.dialog2)(bitbucketPluginGitRest.internal.feature.gitRest.pullRequest.rebase.rebasePullRequest.confirmDialog(getBranchLozenges(pullRequest)));

            dialog.show().$el.find('.confirm-button').click(function (_ref5) {
                var target = _ref5.target;

                (0, _submitSpinner2.default)(target, 'before').show();
                (0, _jquery2.default)(target.parentNode).find('button').prop('disabled', true);

                rebasePullRequest(pullRequest).always(function () {
                    return dialog.hide();
                });
            }).end().find('.cancel-button').click(function () {
                return dialog.hide();
            }).focus();
        });
    }
});