define('bitbucket-plugin-branch/internal/feature/branch/branch-copy/feature/branch-copy', ['exports', '@atlassian/aui', 'clipboard', 'jquery', 'lodash', 'bitbucket/util/events'], function (exports, _aui, _clipboard, _jquery, _lodash, _events) {
    'use strict';

    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.bindToDropdownLink = bindToDropdownLink;

    var _clipboard2 = _interopRequireDefault(_clipboard);

    var _jquery2 = _interopRequireDefault(_jquery);

    var _events2 = _interopRequireDefault(_events);

    function _interopRequireDefault(obj) {
        return obj && obj.__esModule ? obj : {
            default: obj
        };
    }

    /**
     * Binds the branch copy functionality to a AUI dropdown2 menu item
     *
     * @param {string} linkSelector Selector for the menu item that triggers the branch name copy
     * @param {string} dropDownSelector Selector for the Dropdown2
     * @param {Function} getBranchName Function that returns the branch or ref name
     * @param {string} context - 'list' or 'selector' to denote the source of the dropdown link,
     *                           either the branch list or a branch selector
     */
    function bindToDropdownLink(linkSelector, dropDownSelector, getBranchName, context) {
        //selecting on the document as the drop down is absolutely positioned and may not have a parent other than the document
        (0, _jquery2.default)(document).on('aui-dropdown2-show', dropDownSelector, function () {
            var $dropdownMenu = (0, _jquery2.default)(this);
            var branchName = getBranchName($dropdownMenu);
            var clipboard = void 0;

            function afterCopy() {
                // Can't do it on aui-dropdown2-hide event because of ordering issues
                (0, _aui.flag)({
                    type: 'success',
                    title: _aui.I18n.getText('bitbucket.branch.copy.copied'),
                    close: 'auto'
                });
                _events2.default.trigger('bitbucket.internal.DO_NOT_USE.feature.branch-copy.branchNameCopied', null, {
                    name: branchName,
                    context: context,
                    webItemKey: (0, _jquery2.default)(this).data('web-item-key')
                });
                $dropdownMenu.hide();
            }

            (0, _lodash.defer)(function () {
                clipboard = new _clipboard2.default(linkSelector, {
                    text: function text() {
                        return branchName;
                    }
                });
                clipboard.on('success', afterCopy);

                // clipboard.js doesn't really catch the click event, instead we block them here
                (0, _jquery2.default)(linkSelector).on('click', function (e) {
                    e.preventDefault();
                });
            });

            $dropdownMenu.on('aui-dropdown2-hide', (0, _lodash.debounce)(function () {
                clipboard.destroy();
            }));
        });
    }
});