'use strict';

/* global jQuery:false */
jQuery(document).ready(function () {
    require(['@atlassian/aui', 'chaperone', 'bitbucket/internal/util/client-storage', 'bitbucket/internal/util/events'], function (AJS, Chaperone, clientStorage, events) {
        function isComingFromBranchCreation() {
            var createdDate = clientStorage.getFlashItem('stash.branch.created');

            // if they took longer than 30 sec, they probably went somewhere else in between and it'd be weird to show them this.
            return createdDate + 30 * 1000 > new Date().getTime();
        }

        function showActionDiscovery() {
            Chaperone.registerFeature('branch-created-actions-discovery', [{
                id: 'action-discovery',
                selector: '.branch-selector-toolbar .aui-toolbar2-primary .aui-buttons',
                alignment: 'left top',
                title: AJS.I18n.getText('bitbucket.web.branch.actions.feature.discovery.title'),
                content: bitbucket.internal.widget.paragraph.paragraph({
                    text: AJS.I18n.getText('bitbucket.web.branch.actions.feature.discovery.content')
                }),
                once: true
            }]);
        }

        events.on('bitbucket.internal.DO_NOT_USE.feature.branch-creation.branchCreated', function () {
            clientStorage.setFlashItem('stash.branch.created', new Date().getTime());
        });

        if (isComingFromBranchCreation()) {
            showActionDiscovery();
        }
    });
});