'use strict';

define('bitbucket-plugin-branch/internal/feature/branch/branch-deletion/branch-deletion', ['@atlassian/aui', 'jquery', 'lodash', 'bitbucket/util/navbuilder', 'bitbucket/internal/model/page-state', 'bitbucket/internal/util/ajax', 'bitbucket/internal/util/events', 'bitbucket/internal/util/shortcuts', 'bitbucket/internal/widget/confirm-dialog/confirm-dialog', 'exports'], function (AJS, $, _, nav, pageState, ajax, events, shortcuts, ConfirmDialog, exports) {
    'use strict';

    var linkSelector = '.delete-branch';
    var DIALOG_BODY_CLASS = 'branch-delete-content';

    function createConfirmationDialog() {
        var dialog = new ConfirmDialog({
            id: 'delete-branch-dialog',
            titleText: AJS.I18n.getText('bitbucket.feature.branch-deletion.dialog.title'),
            titleClass: 'warning-header',
            panelContent: bitbucketPluginBranch.internal.feature.branch.branchDeletion.branchDeletion.dialog(),
            panelClass: DIALOG_BODY_CLASS,
            submitText: AJS.I18n.getText('bitbucket.web.button.delete'),
            submitToHref: false
        });

        dialog.addConfirmListener(function (promise, $trigger, removeDialog, dialog, $confirmButton) {
            var branchId = getBranchData($trigger, 'id');
            var branchDisplayId = getBranchData($trigger, 'display-id');
            var latestCommit = getBranchData($trigger, 'latest-commit');
            $confirmButton.busy();
            deleteBranchByRest(branchDisplayId, latestCommit).done(function () {
                events.trigger('bitbucket.internal.DO_NOT_USE.page.branches.revisionRefRemoved', null, {
                    id: branchId,
                    displayId: branchDisplayId,
                    latestCommit: latestCommit
                });
            }).fail(function (xhr, textStatus, errorThrown, data) {
                addErrorNotifications(data && data.errors);
            }).always(removeDialog);
        });

        dialog.attachTo(linkSelector, function (trigger, dialog, dialogContext) {
            var branchId = getBranchData(trigger, 'id');
            var branchName = getBranchData(trigger, 'display-id');
            dialog.$el.find('.branch-name').text(branchName);

            //the href is of the form #<ahead number>
            var ahead = parseInt($(trigger).attr('href').substring(1), 10);

            if (ahead > 0) {
                var baseRefDisplayId = pageState.getRevisionRef().get('displayId');
                dialog.$el.find('.' + DIALOG_BODY_CLASS).append(bitbucketPluginBranch.internal.feature.branch.branchDeletion.branchDeletion.aheadWarning({
                    ahead: ahead,
                    baseRefDisplayId: baseRefDisplayId
                }));
            }

            // branch id contains '/' and other special characters which doesn't work with jquery selector
            // hence these are escaped using .replace e.g. '/' becomes '\\/'
            // after jquery upgrade v3.5+ use $.escapeSelector instead
            var $dialogTriggerEl = $('#branch-list-actions-' + branchId.replace(/(\\|:|\.|\[|\]|,|=|@|\/)/g, '\\$1'));

            if ($dialogTriggerEl) {
                dialogContext.setFocusTriggerElOnHide($dialogTriggerEl);
            }
        }, document);
    }

    function deleteBranchByRest(branchName, latestCommit) {
        return ajax.rest({
            url: getBranchRestUrl(),
            type: 'DELETE',
            data: {
                name: branchName,
                endPoint: latestCommit
            },
            statusCode: {
                400: false,
                403: false,
                409: false
            }
        });
    }

    function getBranchData(trigger, dataKey) {
        var attr = 'data-' + dataKey;

        return $(trigger).closest('[' + attr + ']').attr(attr);
    }

    function getBranchRestUrl() {
        return nav.rest('branch-utils').project(pageState.getProject().getKey()).repo(pageState.getRepository().getSlug()).addPathComponents('branches').build();
    }

    function addErrorNotifications(errors) {
        if (errors && errors.length > 0) {
            var errorBody = '';
            _.forEach(errors, function (error) {
                errorBody += bitbucket.internal.widget.exception.exception.errorContent(error);
            });

            AJS.flag({
                type: 'error',
                body: errorBody
            });
        }
    }

    exports.onReady = function () {
        createConfirmationDialog();

        shortcuts.bind('branchlist.deleteBranch', function () {
            $('#branch-list tr.focused .delete-branch').click();
        });
    };
});