'use strict';

define('bitbucket/internal/feature/branch-info/common', ['jquery', 'lodash', 'bitbucket/util/navbuilder', 'bitbucket/internal/util/ajax', 'exports', 'bitbucket/util/state'], function ($, _, nav, ajax, exports, pageState) {
    var MAX_BRANCHES = 10;

    function getBranchesUrl(commitId) {
        return nav.rest('branch-utils').repository(pageState.getRepository()).addPathComponents('branches', 'info', commitId).withParams({ limit: MAX_BRANCHES }).build();
    }

    function getCommitsUrl(branch) {
        return nav.repository(pageState.getRepository()).commits().withParams(!branch.isDefault ? { until: branch.id } : {}).build();
    }

    exports.queryBranchInfoAndDecorate = function (ctx, placeholderSelector, decorationProvider, errorProvider, onShow) {
        ajax.rest({
            url: getBranchesUrl(ctx.commitId),
            statusCode: {
                500: function _() {
                    var $placeholder = $(placeholderSelector);
                    $placeholder.replaceWith(errorProvider({}));

                    return false;
                }
            }
        }).done(function (data) {
            var branches = _.map(data.values, function (ref) {
                return {
                    url: getCommitsUrl(ref),
                    name: ref.displayId
                };
            });
            var $placeholder = $(placeholderSelector);

            $placeholder.replaceWith(decorationProvider({
                branches: branches,
                more: !data.isLastPage
            }));
            if (onShow) {
                onShow($placeholder);
            }
        });
    };
});